/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataIntElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataRealElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataStringElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DatumMarker
extends Command {
    public DatumMarker() {
        this("__datatool_datum:nnnn");
    }

    public DatumMarker(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new DatumMarker(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        return TeXParserUtils.toList(teXObject, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        TeXParserUtils.process(teXObject, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public static boolean isDatumMarker(TeXObject teXObject) {
        return teXObject instanceof DatumMarker || teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("__datatool_datum:nnnn");
    }

    public static DataElement popDataElement(boolean bl, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = DatumMarker.isDatumMarker(teXObject) ? TeXParserUtils.popArg(teXParser, teXObjectList) : teXObject;
        TeXObject teXObject3 = TeXParserUtils.popArg(teXParser, teXObjectList);
        TeXObject teXObject4 = TeXParserUtils.popArg(teXParser, teXObjectList);
        int n = TeXParserUtils.popInt(teXParser, teXObjectList);
        if (bl) {
            TeXNumber teXNumber;
            if (teXObject3 == null) {
                if (teXObject2.isEmpty() && n == -1) {
                    return new DatumElement();
                }
                return new DatumElement(teXObject2);
            }
            if (teXObject3 instanceof TeXNumber) {
                teXNumber = (TeXNumber)teXObject3;
            } else {
                String string = teXParser.expandToString(teXObject3, teXObjectList);
                teXNumber = n == 1 ? new UserNumber(DataToolBaseSty.parseInt(string, teXParser)) : (n == 3 ? new TeXFloatingPoint(DataToolBaseSty.parseCurrencyDecimal(string, teXParser)) : new TeXFloatingPoint(DataToolBaseSty.parseDecimal(string, teXParser)));
            }
            return new DatumElement(teXObject2, teXNumber, teXObject4, DatumType.toDatumType(n));
        }
        String string = teXObject3 == null ? null : teXParser.expandToString(teXObject3, teXObjectList);
        switch (n) {
            case 1: {
                return new DataIntElement(DataToolBaseSty.parseInt(string, teXParser));
            }
            case 2: {
                return new DataRealElement(DataToolBaseSty.parseDecimal(string, teXParser));
            }
            case 3: {
                return new DataCurrencyElement(teXObject4, DataToolBaseSty.parseDecimal(string, teXParser));
            }
        }
        return new DataStringElement(TeXParserUtils.toList(teXObject2, teXParser));
    }
}

