/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

public class MeasurementRange<E extends Number>
extends NumberRange<E> {
    private static final long serialVersionUID = -3532903747339978756L;
    private final Unit<?> unit;

    public static MeasurementRange<Float> create(float f, boolean bl, float f2, boolean bl2, Unit<?> unit) {
        Float f3;
        Float f4;
        return MeasurementRange.unique(new MeasurementRange<Float>(Float.class, f4, bl, Objects.equals(f4 = MeasurementRange.valueOf("minValue", f, Float.NEGATIVE_INFINITY), f3 = MeasurementRange.valueOf("maxValue", f2, Float.POSITIVE_INFINITY)) ? f4 : f3, bl2, unit));
    }

    public static MeasurementRange<Double> create(double d, boolean bl, double d2, boolean bl2, Unit<?> unit) {
        Double d3;
        Double d4;
        return MeasurementRange.unique(new MeasurementRange<Double>(Double.class, d4, bl, Objects.equals(d4 = MeasurementRange.valueOf("minValue", d, Double.NEGATIVE_INFINITY), d3 = MeasurementRange.valueOf("maxValue", d2, Double.POSITIVE_INFINITY)) ? d4 : d3, bl2, unit));
    }

    public static MeasurementRange<Double> createGreaterThan(double d, Unit<?> unit) {
        return MeasurementRange.unique(new MeasurementRange<Object>((Class<Object>)Double.class, MeasurementRange.valueOf("minValue", d, Double.NEGATIVE_INFINITY), false, null, false, unit));
    }

    public static MeasurementRange<?> createBestFit(Number number, boolean bl, Number number2, boolean bl2, Unit<?> unit) {
        boolean bl3;
        Class<? extends Number> clazz = Numbers.widestClass(Numbers.narrowestClass(number), Numbers.narrowestClass(number2));
        if (clazz == null) {
            return null;
        }
        Number number3 = Numbers.cast(number, clazz);
        Number number4 = Numbers.cast(number2, clazz);
        boolean bl4 = bl3 = MeasurementRange.isCacheable(number3) && MeasurementRange.isCacheable(number4);
        if (bl3 && Objects.equals(number3, number4)) {
            number4 = number3;
        }
        MeasurementRange<Number> measurementRange = new MeasurementRange<Number>(clazz, number3, bl, number4, bl2, unit);
        if (bl3) {
            measurementRange = MeasurementRange.unique(measurementRange);
        }
        return measurementRange;
    }

    public MeasurementRange(Range<E> range, Unit<?> unit) {
        super(range);
        this.unit = unit;
    }

    public MeasurementRange(Class<E> clazz, ValueRange valueRange, Unit<?> unit) throws IllegalArgumentException {
        super(clazz, valueRange);
        this.unit = unit;
    }

    public MeasurementRange(Class<E> clazz, E e, boolean bl, E e2, boolean bl2, Unit<?> unit) {
        super(clazz, e, bl, e2, bl2);
        this.unit = unit;
    }

    private MeasurementRange(Class<E> clazz, Range<? extends Number> range, Unit<?> unit) {
        super(clazz, range);
        this.unit = unit;
    }

    @Override
    Range<E> create(E e, boolean bl, E e2, boolean bl2) {
        return new MeasurementRange<E>(this.elementType, e, bl, e2, bl2, this.unit);
    }

    @Override
    public Unit<?> unit() {
        return this.unit;
    }

    public MeasurementRange<E> convertTo(Unit<?> unit) throws IncommensurableException {
        return this.convertAndCast(this.elementType, unit);
    }

    @Override
    public <N extends Number> MeasurementRange<N> castTo(Class<N> clazz) {
        if (this.elementType == clazz) {
            return this;
        }
        return new MeasurementRange<N>(clazz, this, this.unit);
    }

    private <N extends E> Range<N> convert(Range<N> range) throws IllegalArgumentException {
        if (range instanceof MeasurementRange) {
            try {
                return ((MeasurementRange)range).convertAndCast(range.elementType, this.unit);
            }
            catch (IncommensurableException incommensurableException) {
                throw new IllegalArgumentException(Errors.format((short)66, ((MeasurementRange)range).unit, this.unit), incommensurableException);
            }
        }
        return range;
    }

    @Override
    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> numberRange, Class<N> clazz) throws IllegalArgumentException {
        if (numberRange instanceof MeasurementRange) {
            try {
                return ((MeasurementRange)numberRange).convertAndCast(clazz, this.unit);
            }
            catch (IncommensurableException incommensurableException) {
                throw new IllegalArgumentException(Errors.format((short)66, ((MeasurementRange)numberRange).unit, this.unit), incommensurableException);
            }
        }
        return new MeasurementRange<N>(clazz, numberRange, this.unit);
    }

    @Override
    private <N extends Number> MeasurementRange<N> convertAndCast(Class<N> clazz, Unit<?> unit) throws IncommensurableException {
        UnitConverter unitConverter;
        if (unit == null || unit.equals(this.unit)) {
            if (this.elementType == clazz) {
                return this;
            }
            unit = this.unit;
        } else if (this.unit != null && !(unitConverter = this.unit.getConverterToAny(unit)).isIdentity()) {
            double d;
            boolean bl = this.isMinIncluded;
            boolean bl2 = this.isMaxIncluded;
            double d2 = unitConverter.convert(this.getMinDouble());
            if (d2 > (d = unitConverter.convert(this.getMaxDouble()))) {
                double d3 = d2;
                d2 = d;
                d = d3;
                boolean bl3 = bl;
                bl = bl2;
                bl2 = bl3;
            }
            if (Numbers.isInteger(clazz)) {
                bl &= d2 == (d2 = Math.floor(d2));
                double d4 = d;
                d = Math.ceil(d);
                bl2 &= d4 == d;
            }
            return new MeasurementRange<N>(clazz, Numbers.cast(d2, clazz), bl, Numbers.cast(d, clazz), bl2, unit);
        }
        return new MeasurementRange<N>(clazz, this, unit);
    }

    @Override
    final Range<E>[] newArray(int n) {
        return new MeasurementRange[n];
    }

    @Override
    public boolean contains(Range<? extends E> range) throws IllegalArgumentException {
        return super.contains(this.convert(range));
    }

    @Override
    public boolean intersects(Range<? extends E> range) throws IllegalArgumentException {
        return super.intersects(this.convert(range));
    }

    @Override
    public Range<E> intersect(Range<E> range) throws IllegalArgumentException {
        return super.intersect(this.convert(range));
    }

    @Override
    public Range<E> union(Range<E> range) throws IllegalArgumentException {
        return super.union(this.convert(range));
    }

    @Override
    public Range<E>[] subtract(Range<E> range) throws IllegalArgumentException {
        return super.subtract(this.convert(range));
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.unit, ((MeasurementRange)object).unit);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.unit);
    }
}

