/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.events.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.apache.solr.api.ContainerPluginsRegistry;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cluster.events.ClusterEvent;
import org.apache.solr.cluster.events.ClusterEventListener;
import org.apache.solr.cluster.events.ClusterEventProducer;
import org.apache.solr.cluster.events.ClusterEventProducerBase;
import org.apache.solr.cluster.events.NoOpProducer;
import org.apache.solr.cluster.events.impl.DelegatingClusterEventProducer;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEventProducerFactory
extends ClusterEventProducerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ContainerPluginsRegistry.PluginRegistryListener initialPluginListener = new ContainerPluginsRegistry.PluginRegistryListener(){

        @Override
        public void added(ContainerPluginsRegistry.ApiInfo plugin) {
            if (plugin == null || plugin.getInstance() == null) {
                return;
            }
            Object instance = plugin.getInstance();
            if (instance instanceof ClusterEventListener) {
                ClusterEventProducerFactory.this.registerListener((ClusterEventListener)instance, new ClusterEvent.EventType[0]);
            }
        }

        @Override
        public void deleted(ContainerPluginsRegistry.ApiInfo plugin) {
            if (plugin == null || plugin.getInstance() == null) {
                return;
            }
            Object instance = plugin.getInstance();
            if (instance instanceof ClusterEventListener) {
                ClusterEventProducerFactory.this.unregisterListener((ClusterEventListener)instance);
            }
        }

        @Override
        public void modified(ContainerPluginsRegistry.ApiInfo old, ContainerPluginsRegistry.ApiInfo replacement) {
            this.added(replacement);
            this.deleted(old);
        }
    };
    private boolean created = false;

    public ClusterEventProducerFactory(CoreContainer cc) {
        super(cc);
    }

    @Override
    public Set<ClusterEvent.EventType> getSupportedEventTypes() {
        return NoOpProducer.ALL_EVENT_TYPES;
    }

    public ContainerPluginsRegistry.PluginRegistryListener getPluginRegistryListener() {
        return this.initialPluginListener;
    }

    public DelegatingClusterEventProducer create(ContainerPluginsRegistry plugins) {
        if (this.created) {
            throw new RuntimeException("this factory can be called only once!");
        }
        final DelegatingClusterEventProducer clusterEventProducer = new DelegatingClusterEventProducer(this.cc);
        this.cc.getClusterSingletons().getSingletons().put(".cluster-event-producer_delegate", clusterEventProducer);
        ContainerPluginsRegistry.ApiInfo clusterEventProducerInfo = plugins.getPlugin(".cluster-event-producer");
        if (clusterEventProducerInfo != null) {
            clusterEventProducer.setDelegate((ClusterEventProducer)clusterEventProducerInfo.getInstance());
        }
        this.transferListeners(clusterEventProducer, plugins);
        ContainerPluginsRegistry.PluginRegistryListener pluginListener = new ContainerPluginsRegistry.PluginRegistryListener(){

            @Override
            public void added(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof ClusterEventListener) {
                    ClusterEventListener listener = (ClusterEventListener)instance;
                    clusterEventProducer.registerListener(listener, new ClusterEvent.EventType[0]);
                } else if (instance instanceof ClusterEventProducer) {
                    if (".cluster-event-producer".equals(plugin.getInfo().name)) {
                        if (ClusterEventProducerFactory.this.cc.getClusterEventProducer() instanceof DelegatingClusterEventProducer) {
                            ((DelegatingClusterEventProducer)ClusterEventProducerFactory.this.cc.getClusterEventProducer()).setDelegate((ClusterEventProducer)instance);
                        } else {
                            log.warn("Can't configure plugin-based ClusterEventProducer while CoreContainer is still loading -  using existing implementation {}", (Object)ClusterEventProducerFactory.this.cc.getClusterEventProducer().getClass().getName());
                        }
                    } else {
                        log.warn("Ignoring ClusterEventProducer config with non-standard name: {}", (Object)plugin.getInfo());
                    }
                }
            }

            @Override
            public void deleted(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof ClusterEventListener) {
                    ClusterEventListener listener = (ClusterEventListener)instance;
                    clusterEventProducer.unregisterListener(listener);
                } else if (instance instanceof ClusterEventProducer) {
                    if (".cluster-event-producer".equals(plugin.getInfo().name)) {
                        if (ClusterEventProducerFactory.this.cc.getClusterEventProducer() instanceof DelegatingClusterEventProducer) {
                            ((DelegatingClusterEventProducer)ClusterEventProducerFactory.this.cc.getClusterEventProducer()).setDelegate(new NoOpProducer(ClusterEventProducerFactory.this.cc));
                        } else {
                            log.warn("Can't configure plugin-based ClusterEventProducer while CoreContainer is still loading -  using existing implementation {}", (Object)ClusterEventProducerFactory.this.cc.getClusterEventProducer().getClass().getName());
                        }
                    } else {
                        log.warn("Ignoring ClusterEventProducer config with non-standard name: {}", (Object)plugin.getInfo());
                    }
                }
            }

            @Override
            public void modified(ContainerPluginsRegistry.ApiInfo old, ContainerPluginsRegistry.ApiInfo replacement) {
                this.deleted(old);
                this.added(replacement);
            }
        };
        plugins.registerListener(pluginListener);
        this.created = true;
        return clusterEventProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferListeners(ClusterEventProducer target, ContainerPluginsRegistry plugins) {
        Map map = this.listeners;
        synchronized (map) {
            plugins.unregisterListener(this.initialPluginListener);
            this.listeners.forEach((type, listenersSet) -> listenersSet.forEach(listener -> target.registerListener((ClusterEventListener)listener, (ClusterEvent.EventType)((Object)type))));
            this.listeners.clear();
        }
    }

    @Override
    public void start() throws Exception {
        this.state = ClusterSingleton.State.RUNNING;
    }

    @Override
    public void stop() {
        this.state = ClusterSingleton.State.STOPPED;
    }
}

