\name{BinaryMorphologicalClosingImageFilter}
\alias{BinaryMorphologicalClosingImageFilter}
\title{BinaryMorphologicalClosingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
binary morphological closing of an image.
BinaryMorphologicalClosingImageFilter}
\details{
This filter removes small (i.e., smaller than the structuring element)
holes and tube like structures in the interior or at the boundaries of
the image. The morphological closing of an image "f" is defined as:
Closing(f) = Erosion(Dilation(f)).
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.
This code was contributed in the Insight Journal paper: "Binary
morphological closing and opening image filters" by Lehmann G. https://www.insight-journal.org/browse/publication/58
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter
BinaryMorphologicalClosing for the procedural interface
itk::BinaryMorphologicalClosingImageFilter for the Doxygen on the original ITK class.
BinaryMorphologicalClosingImageFilter}
%C++ includes: sitkBinaryMorphologicalClosingImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryMorphologicalClosingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetForegroundValue() const:}{
Get the value in the image considered as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSafeBorder() const:}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{Self SafeBorderOff():}{}
\item{Self SafeBorderOn():}{
Set the value of SafeBorder to true or false respectfully.
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value in the image to consider as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetSafeBorder(bool SafeBorder):}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryMorphologicalClosingImageFilter():}{
Destructor
}
}
}
