/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttConstraintMode;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.RegexResult;

abstract class AbstractComplementTaskInstant
implements Something<GanttDiagram> {
    AbstractComplementTaskInstant() {
    }

    public final Failable<TaskInstant> getComplementTaskInstant(GanttDiagram system, RegexResult arg, String suffix) {
        String code = arg.get("COMPLEMENT_CODE_OTHER" + suffix, 0);
        String startOrEnd = arg.get("COMPLEMENT_START_OR_END" + suffix, 0);
        Moment task = system.getExistingMoment(code);
        if (task == null) {
            return Failable.error("No such task " + code);
        }
        TaskInstant result = new TaskInstant(task, TaskAttribute.fromString(startOrEnd));
        String nb1 = arg.get("COMPLEMENT_NB1" + suffix, 0);
        if (nb1 != null) {
            int factor1 = arg.get("COMPLEMENT_DAY_OR_WEEK1" + suffix, 0).startsWith("w") ? system.daysInWeek() : 1;
            int days1 = Integer.parseInt(nb1) * factor1;
            String nb2 = arg.get("COMPLEMENT_NB2" + suffix, 0);
            int days2 = 0;
            if (nb2 != null) {
                int factor2 = arg.get("COMPLEMENT_DAY_OR_WEEK2" + suffix, 0).startsWith("w") ? system.daysInWeek() : 1;
                days2 = Integer.parseInt(nb2) * factor2;
            }
            int delta = days1 + days2;
            if ("before".equalsIgnoreCase(arg.get("COMPLEMENT_BEFORE_OR_AFTER" + suffix, 0))) {
                delta = -delta;
            }
            boolean working = arg.get("COMPLEMENT_WORKING1" + suffix, 0) != null || arg.get("COMPLEMENT_WORKING2" + suffix, 0) != null;
            GanttConstraintMode mode = working ? GanttConstraintMode.DO_NOT_COUNT_CLOSE_DAY : GanttConstraintMode.IGNORE_CALENDAR;
            result = result.withDelta(delta, mode, system.getDefaultPlan());
        }
        return Failable.ok(result);
    }
}

