/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ExportViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncrementalExportSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncrementalExportSpecification> {
    private static final SdkField<Instant> EXPORT_FROM_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExportFromTime").getter(IncrementalExportSpecification.getter(IncrementalExportSpecification::exportFromTime)).setter(IncrementalExportSpecification.setter(Builder::exportFromTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFromTime").build()}).build();
    private static final SdkField<Instant> EXPORT_TO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExportToTime").getter(IncrementalExportSpecification.getter(IncrementalExportSpecification::exportToTime)).setter(IncrementalExportSpecification.setter(Builder::exportToTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToTime").build()}).build();
    private static final SdkField<String> EXPORT_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportViewType").getter(IncrementalExportSpecification.getter(IncrementalExportSpecification::exportViewTypeAsString)).setter(IncrementalExportSpecification.setter(Builder::exportViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportViewType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FROM_TIME_FIELD, EXPORT_TO_TIME_FIELD, EXPORT_VIEW_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncrementalExportSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant exportFromTime;
    private final Instant exportToTime;
    private final String exportViewType;

    private IncrementalExportSpecification(BuilderImpl builder) {
        this.exportFromTime = builder.exportFromTime;
        this.exportToTime = builder.exportToTime;
        this.exportViewType = builder.exportViewType;
    }

    public final Instant exportFromTime() {
        return this.exportFromTime;
    }

    public final Instant exportToTime() {
        return this.exportToTime;
    }

    public final ExportViewType exportViewType() {
        return ExportViewType.fromValue(this.exportViewType);
    }

    public final String exportViewTypeAsString() {
        return this.exportViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFromTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportViewTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalExportSpecification)) {
            return false;
        }
        IncrementalExportSpecification other = (IncrementalExportSpecification)obj;
        return Objects.equals(this.exportFromTime(), other.exportFromTime()) && Objects.equals(this.exportToTime(), other.exportToTime()) && Objects.equals(this.exportViewTypeAsString(), other.exportViewTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IncrementalExportSpecification").add("ExportFromTime", (Object)this.exportFromTime()).add("ExportToTime", (Object)this.exportToTime()).add("ExportViewType", (Object)this.exportViewTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportFromTime": {
                return Optional.ofNullable(clazz.cast(this.exportFromTime()));
            }
            case "ExportToTime": {
                return Optional.ofNullable(clazz.cast(this.exportToTime()));
            }
            case "ExportViewType": {
                return Optional.ofNullable(clazz.cast(this.exportViewTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportFromTime", EXPORT_FROM_TIME_FIELD);
        map.put("ExportToTime", EXPORT_TO_TIME_FIELD);
        map.put("ExportViewType", EXPORT_VIEW_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalExportSpecification, T> g) {
        return obj -> g.apply((IncrementalExportSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant exportFromTime;
        private Instant exportToTime;
        private String exportViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalExportSpecification model) {
            this.exportFromTime(model.exportFromTime);
            this.exportToTime(model.exportToTime);
            this.exportViewType(model.exportViewType);
        }

        public final Instant getExportFromTime() {
            return this.exportFromTime;
        }

        public final void setExportFromTime(Instant exportFromTime) {
            this.exportFromTime = exportFromTime;
        }

        @Override
        public final Builder exportFromTime(Instant exportFromTime) {
            this.exportFromTime = exportFromTime;
            return this;
        }

        public final Instant getExportToTime() {
            return this.exportToTime;
        }

        public final void setExportToTime(Instant exportToTime) {
            this.exportToTime = exportToTime;
        }

        @Override
        public final Builder exportToTime(Instant exportToTime) {
            this.exportToTime = exportToTime;
            return this;
        }

        public final String getExportViewType() {
            return this.exportViewType;
        }

        public final void setExportViewType(String exportViewType) {
            this.exportViewType = exportViewType;
        }

        @Override
        public final Builder exportViewType(String exportViewType) {
            this.exportViewType = exportViewType;
            return this;
        }

        @Override
        public final Builder exportViewType(ExportViewType exportViewType) {
            this.exportViewType(exportViewType == null ? null : exportViewType.toString());
            return this;
        }

        public IncrementalExportSpecification build() {
            return new IncrementalExportSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncrementalExportSpecification> {
        public Builder exportFromTime(Instant var1);

        public Builder exportToTime(Instant var1);

        public Builder exportViewType(String var1);

        public Builder exportViewType(ExportViewType var1);
    }
}

