/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;

public class DescribeVpcPeeringConnectionsIterable
implements SdkIterable<DescribeVpcPeeringConnectionsResponse> {
    private final Ec2Client client;
    private final DescribeVpcPeeringConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcPeeringConnectionsIterable(Ec2Client client, DescribeVpcPeeringConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVpcPeeringConnectionsResponseFetcher();
    }

    public Iterator<DescribeVpcPeeringConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcPeeringConnection> vpcPeeringConnections() {
        Function<DescribeVpcPeeringConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcPeeringConnections() != null) {
                return response.vpcPeeringConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcPeeringConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeVpcPeeringConnectionsResponse> {
        private DescribeVpcPeeringConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcPeeringConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcPeeringConnectionsResponse nextPage(DescribeVpcPeeringConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcPeeringConnectionsIterable.this.client.describeVpcPeeringConnections(DescribeVpcPeeringConnectionsIterable.this.firstRequest);
            }
            return DescribeVpcPeeringConnectionsIterable.this.client.describeVpcPeeringConnections((DescribeVpcPeeringConnectionsRequest)((Object)DescribeVpcPeeringConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

