/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GatewayAssociationState;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VgwTelemetryListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptions;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.model.VpnStaticRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnection> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(VpnConnection.getter(VpnConnection::category)).setter(VpnConnection.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").unmarshallLocationName("category").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(VpnConnection.getter(VpnConnection::transitGatewayId)).setter(VpnConnection.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkArn").getter(VpnConnection.getter(VpnConnection::coreNetworkArn)).setter(VpnConnection.setter(Builder::coreNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").unmarshallLocationName("coreNetworkArn").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkAttachmentArn").getter(VpnConnection.getter(VpnConnection::coreNetworkAttachmentArn)).setter(VpnConnection.setter(Builder::coreNetworkAttachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAttachmentArn").unmarshallLocationName("coreNetworkAttachmentArn").build()}).build();
    private static final SdkField<String> GATEWAY_ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayAssociationState").getter(VpnConnection.getter(VpnConnection::gatewayAssociationStateAsString)).setter(VpnConnection.setter(Builder::gatewayAssociationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayAssociationState").unmarshallLocationName("gatewayAssociationState").build()}).build();
    private static final SdkField<VpnConnectionOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(VpnConnection.getter(VpnConnection::options)).setter(VpnConnection.setter(Builder::options)).constructor(VpnConnectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("options").build()}).build();
    private static final SdkField<List<VpnStaticRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(VpnConnection.getter(VpnConnection::routes)).setter(VpnConnection.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").unmarshallLocationName("routes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnStaticRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VpnConnection.getter(VpnConnection::tags)).setter(VpnConnection.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<VgwTelemetry>> VGW_TELEMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VgwTelemetry").getter(VpnConnection.getter(VpnConnection::vgwTelemetry)).setter(VpnConnection.setter(Builder::vgwTelemetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VgwTelemetry").unmarshallLocationName("vgwTelemetry").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VgwTelemetry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(VpnConnection.getter(VpnConnection::vpnConnectionId)).setter(VpnConnection.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("vpnConnectionId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VpnConnection.getter(VpnConnection::stateAsString)).setter(VpnConnection.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayConfiguration").getter(VpnConnection.getter(VpnConnection::customerGatewayConfiguration)).setter(VpnConnection.setter(Builder::customerGatewayConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayConfiguration").unmarshallLocationName("customerGatewayConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(VpnConnection.getter(VpnConnection::typeAsString)).setter(VpnConnection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerGatewayId").getter(VpnConnection.getter(VpnConnection::customerGatewayId)).setter(VpnConnection.setter(Builder::customerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("customerGatewayId").build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnGatewayId").getter(VpnConnection.getter(VpnConnection::vpnGatewayId)).setter(VpnConnection.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("vpnGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, TRANSIT_GATEWAY_ID_FIELD, CORE_NETWORK_ARN_FIELD, CORE_NETWORK_ATTACHMENT_ARN_FIELD, GATEWAY_ASSOCIATION_STATE_FIELD, OPTIONS_FIELD, ROUTES_FIELD, TAGS_FIELD, VGW_TELEMETRY_FIELD, VPN_CONNECTION_ID_FIELD, STATE_FIELD, CUSTOMER_GATEWAY_CONFIGURATION_FIELD, TYPE_FIELD, CUSTOMER_GATEWAY_ID_FIELD, VPN_GATEWAY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpnConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String transitGatewayId;
    private final String coreNetworkArn;
    private final String coreNetworkAttachmentArn;
    private final String gatewayAssociationState;
    private final VpnConnectionOptions options;
    private final List<VpnStaticRoute> routes;
    private final List<Tag> tags;
    private final List<VgwTelemetry> vgwTelemetry;
    private final String vpnConnectionId;
    private final String state;
    private final String customerGatewayConfiguration;
    private final String type;
    private final String customerGatewayId;
    private final String vpnGatewayId;

    private VpnConnection(BuilderImpl builder) {
        this.category = builder.category;
        this.transitGatewayId = builder.transitGatewayId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.coreNetworkAttachmentArn = builder.coreNetworkAttachmentArn;
        this.gatewayAssociationState = builder.gatewayAssociationState;
        this.options = builder.options;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vgwTelemetry = builder.vgwTelemetry;
        this.vpnConnectionId = builder.vpnConnectionId;
        this.state = builder.state;
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.type = builder.type;
        this.customerGatewayId = builder.customerGatewayId;
        this.vpnGatewayId = builder.vpnGatewayId;
    }

    public final String category() {
        return this.category;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String coreNetworkArn() {
        return this.coreNetworkArn;
    }

    public final String coreNetworkAttachmentArn() {
        return this.coreNetworkAttachmentArn;
    }

    public final GatewayAssociationState gatewayAssociationState() {
        return GatewayAssociationState.fromValue(this.gatewayAssociationState);
    }

    public final String gatewayAssociationStateAsString() {
        return this.gatewayAssociationState;
    }

    public final VpnConnectionOptions options() {
        return this.options;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<VpnStaticRoute> routes() {
        return this.routes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasVgwTelemetry() {
        return this.vgwTelemetry != null && !(this.vgwTelemetry instanceof SdkAutoConstructList);
    }

    public final List<VgwTelemetry> vgwTelemetry() {
        return this.vgwTelemetry;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final VpnState state() {
        return VpnState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }

    public final GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String customerGatewayId() {
        return this.customerGatewayId;
    }

    public final String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkAttachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayAssociationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVgwTelemetry() ? this.vgwTelemetry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection)obj;
        return Objects.equals(this.category(), other.category()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(this.coreNetworkAttachmentArn(), other.coreNetworkAttachmentArn()) && Objects.equals(this.gatewayAssociationStateAsString(), other.gatewayAssociationStateAsString()) && Objects.equals(this.options(), other.options()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasVgwTelemetry() == other.hasVgwTelemetry() && Objects.equals(this.vgwTelemetry(), other.vgwTelemetry()) && Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.customerGatewayConfiguration(), other.customerGatewayConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId());
    }

    public final String toString() {
        return ToString.builder((String)"VpnConnection").add("Category", (Object)this.category()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("CoreNetworkArn", (Object)this.coreNetworkArn()).add("CoreNetworkAttachmentArn", (Object)this.coreNetworkAttachmentArn()).add("GatewayAssociationState", (Object)this.gatewayAssociationStateAsString()).add("Options", (Object)this.options()).add("Routes", this.hasRoutes() ? this.routes() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VgwTelemetry", this.hasVgwTelemetry() ? this.vgwTelemetry() : null).add("VpnConnectionId", (Object)this.vpnConnectionId()).add("State", (Object)this.stateAsString()).add("CustomerGatewayConfiguration", (Object)(this.customerGatewayConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("VpnGatewayId", (Object)this.vpnGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "CoreNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkArn()));
            }
            case "CoreNetworkAttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkAttachmentArn()));
            }
            case "GatewayAssociationState": {
                return Optional.ofNullable(clazz.cast(this.gatewayAssociationStateAsString()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VgwTelemetry": {
                return Optional.ofNullable(clazz.cast(this.vgwTelemetry()));
            }
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CustomerGatewayConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayConfiguration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CustomerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayId()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Category", CATEGORY_FIELD);
        map.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
        map.put("CoreNetworkArn", CORE_NETWORK_ARN_FIELD);
        map.put("CoreNetworkAttachmentArn", CORE_NETWORK_ATTACHMENT_ARN_FIELD);
        map.put("GatewayAssociationState", GATEWAY_ASSOCIATION_STATE_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("Routes", ROUTES_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("VgwTelemetry", VGW_TELEMETRY_FIELD);
        map.put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CustomerGatewayConfiguration", CUSTOMER_GATEWAY_CONFIGURATION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("CustomerGatewayId", CUSTOMER_GATEWAY_ID_FIELD);
        map.put("VpnGatewayId", VPN_GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpnConnection, T> g) {
        return obj -> g.apply((VpnConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String transitGatewayId;
        private String coreNetworkArn;
        private String coreNetworkAttachmentArn;
        private String gatewayAssociationState;
        private VpnConnectionOptions options;
        private List<VpnStaticRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<VgwTelemetry> vgwTelemetry = DefaultSdkAutoConstructList.getInstance();
        private String vpnConnectionId;
        private String state;
        private String customerGatewayConfiguration;
        private String type;
        private String customerGatewayId;
        private String vpnGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnection model) {
            this.category(model.category);
            this.transitGatewayId(model.transitGatewayId);
            this.coreNetworkArn(model.coreNetworkArn);
            this.coreNetworkAttachmentArn(model.coreNetworkAttachmentArn);
            this.gatewayAssociationState(model.gatewayAssociationState);
            this.options(model.options);
            this.routes(model.routes);
            this.tags(model.tags);
            this.vgwTelemetry(model.vgwTelemetry);
            this.vpnConnectionId(model.vpnConnectionId);
            this.state(model.state);
            this.customerGatewayConfiguration(model.customerGatewayConfiguration);
            this.type(model.type);
            this.customerGatewayId(model.customerGatewayId);
            this.vpnGatewayId(model.vpnGatewayId);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getCoreNetworkAttachmentArn() {
            return this.coreNetworkAttachmentArn;
        }

        public final void setCoreNetworkAttachmentArn(String coreNetworkAttachmentArn) {
            this.coreNetworkAttachmentArn = coreNetworkAttachmentArn;
        }

        @Override
        public final Builder coreNetworkAttachmentArn(String coreNetworkAttachmentArn) {
            this.coreNetworkAttachmentArn = coreNetworkAttachmentArn;
            return this;
        }

        public final String getGatewayAssociationState() {
            return this.gatewayAssociationState;
        }

        public final void setGatewayAssociationState(String gatewayAssociationState) {
            this.gatewayAssociationState = gatewayAssociationState;
        }

        @Override
        public final Builder gatewayAssociationState(String gatewayAssociationState) {
            this.gatewayAssociationState = gatewayAssociationState;
            return this;
        }

        @Override
        public final Builder gatewayAssociationState(GatewayAssociationState gatewayAssociationState) {
            this.gatewayAssociationState(gatewayAssociationState == null ? null : gatewayAssociationState.toString());
            return this;
        }

        public final VpnConnectionOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(VpnConnectionOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptions options) {
            this.options = options;
            return this;
        }

        public final List<VpnStaticRoute.Builder> getRoutes() {
            List<VpnStaticRoute.Builder> result = VpnStaticRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<VpnStaticRoute.BuilderImpl> routes) {
            this.routes = VpnStaticRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VpnStaticRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<VpnStaticRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (VpnStaticRoute)((VpnStaticRoute.Builder)VpnStaticRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VgwTelemetry.Builder> getVgwTelemetry() {
            List<VgwTelemetry.Builder> result = VgwTelemetryListCopier.copyToBuilder(this.vgwTelemetry);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVgwTelemetry(Collection<VgwTelemetry.BuilderImpl> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copyFromBuilder(vgwTelemetry);
        }

        @Override
        public final Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(VgwTelemetry ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(Consumer<VgwTelemetry.Builder> ... vgwTelemetry) {
            this.vgwTelemetry(Stream.of(vgwTelemetry).map(c -> (VgwTelemetry)((VgwTelemetry.Builder)VgwTelemetry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getCustomerGatewayConfiguration() {
            return this.customerGatewayConfiguration;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public VpnConnection build() {
            return new VpnConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnection> {
        public Builder category(String var1);

        public Builder transitGatewayId(String var1);

        public Builder coreNetworkArn(String var1);

        public Builder coreNetworkAttachmentArn(String var1);

        public Builder gatewayAssociationState(String var1);

        public Builder gatewayAssociationState(GatewayAssociationState var1);

        public Builder options(VpnConnectionOptions var1);

        default public Builder options(Consumer<VpnConnectionOptions.Builder> options) {
            return this.options((VpnConnectionOptions)((VpnConnectionOptions.Builder)VpnConnectionOptions.builder().applyMutation(options)).build());
        }

        public Builder routes(Collection<VpnStaticRoute> var1);

        public Builder routes(VpnStaticRoute ... var1);

        public Builder routes(Consumer<VpnStaticRoute.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vgwTelemetry(Collection<VgwTelemetry> var1);

        public Builder vgwTelemetry(VgwTelemetry ... var1);

        public Builder vgwTelemetry(Consumer<VgwTelemetry.Builder> ... var1);

        public Builder vpnConnectionId(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder customerGatewayConfiguration(String var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder customerGatewayId(String var1);

        public Builder vpnGatewayId(String var1);
    }
}

