/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.utils;

import com.cronutils.utils.WeekendPolicy;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;

public class DateUtils {
    private DateUtils() {
    }

    public static int workdaysCount(ZonedDateTime startDate, int days, List<ZonedDateTime> holidays, WeekendPolicy weekendPolicy) {
        return DateUtils.workdaysCount(startDate, startDate.plusDays(days), holidays, weekendPolicy);
    }

    public static int workdaysCount(ZonedDateTime startDate, ZonedDateTime endDate, List<ZonedDateTime> holidays, WeekendPolicy weekendPolicy) {
        Collections.sort(holidays);
        holidays = DateUtils.holidaysInRange(startDate, endDate, holidays);
        int daysToWeekend = WeekendPolicy.daysToWeekend(weekendPolicy, startDate);
        int daysFromWeekend = WeekendPolicy.daysFromWeekend(weekendPolicy, endDate);
        int daysBetween = (int)Duration.between(startDate, endDate).toDays() + 1;
        int tmpWeekdays = (daysBetween - daysToWeekend - daysFromWeekend - 2) / 7 * 5;
        return (tmpWeekdays -= holidays.size()) + daysToWeekend + daysFromWeekend;
    }

    private static List<ZonedDateTime> holidaysInRange(ZonedDateTime startDate, ZonedDateTime endDate, List<ZonedDateTime> holidays) {
        if (holidays.isEmpty()) {
            return holidays;
        }
        int idxstart = DateUtils.findIdx(0, holidays.size() - 1, startDate, holidays);
        int idxend = DateUtils.findIdx(0, holidays.size() - 1, endDate, holidays);
        return holidays.subList(idxstart, idxend + 1);
    }

    private static int findIdx(int startidx, int endidx, ZonedDateTime endDate, List<ZonedDateTime> holidays) {
        if (startidx == endidx) {
            return startidx;
        }
        int pivot = (endidx - startidx) / 2;
        if (holidays.get(pivot).equals(endDate)) {
            return pivot;
        }
        if (holidays.get(pivot).isBefore(endDate)) {
            return DateUtils.findIdx(++pivot, endidx, endDate, holidays);
        }
        return DateUtils.findIdx(startidx, pivot, endDate, holidays);
    }
}

