/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.bulk;

import java.io.IOException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.protobufs.BulkResponse;
import org.opensearch.protobufs.Item;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.transport.grpc.proto.response.document.bulk.BulkItemResponseProtoUtils;

public class BulkResponseProtoUtils {
    private BulkResponseProtoUtils() {
    }

    public static org.opensearch.protobufs.BulkResponse toProto(BulkResponse response) throws IOException {
        BulkResponse.Builder bulkResponse = org.opensearch.protobufs.BulkResponse.newBuilder();
        bulkResponse.setTook(response.getTook().getMillis());
        if (response.getIngestTookInMillis() != -1L) {
            bulkResponse.setIngestTook(response.getIngestTookInMillis());
        }
        bulkResponse.setErrors(response.hasFailures());
        for (BulkItemResponse bulkItemResponse : response.getItems()) {
            ResponseItem responseItem = BulkItemResponseProtoUtils.toProto(bulkItemResponse);
            Item.Builder itemBuilder = Item.newBuilder();
            switch (bulkItemResponse.getOpType()) {
                case CREATE: {
                    itemBuilder.setCreate(responseItem);
                    break;
                }
                case DELETE: {
                    itemBuilder.setDelete(responseItem);
                    break;
                }
                case INDEX: {
                    itemBuilder.setIndex(responseItem);
                    break;
                }
                case UPDATE: {
                    itemBuilder.setUpdate(responseItem);
                }
            }
            bulkResponse.addItems(itemBuilder.build());
        }
        return bulkResponse.build();
    }
}

