/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.common.io.IndexIOStreamHandler;
import org.opensearch.common.io.IndexIOStreamHandlerFactory;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.opensearch.index.translog.transfer.TranslogTransferMetadataHandler;

public class TranslogTransferMetadataHandlerFactory
implements IndexIOStreamHandlerFactory<TranslogTransferMetadata> {
    private final ConcurrentHashMap<Integer, IndexIOStreamHandler<TranslogTransferMetadata>> handlers = new ConcurrentHashMap();

    @Override
    public IndexIOStreamHandler<TranslogTransferMetadata> getHandler(int version) {
        return this.handlers.computeIfAbsent(version, this::createHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IndexIOStreamHandler<TranslogTransferMetadata> createHandler(int version) {
        switch (version) {
            case 1: {
                return new TranslogTransferMetadataHandler();
            }
            default: {
                throw new IllegalArgumentException("Unsupported TranslogTransferMetadata version: " + version);
            }
        }
    }
}

