/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.util.concurrent.TimeUnit;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MaxMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.index.shard.IndexingStats;
import org.opensearch.threadpool.ThreadPool;

final class InternalIndexingStats
implements IndexingOperationListener {
    private final StatsHolder totalStats = new StatsHolder();
    private final ThreadPool threadPool;

    InternalIndexingStats(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    IndexingStats stats(boolean isThrottled, long currentThrottleInMillis) {
        IndexingStats.Stats total = this.totalStats.stats(isThrottled, currentThrottleInMillis);
        return new IndexingStats(total);
    }

    @Override
    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (!operation.origin().isRecovery()) {
            this.totalStats.indexCurrent.inc();
        }
        return operation;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (index.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.indexMetric.inc(took);
                this.totalStats.indexCurrent.dec();
                long now = this.threadPool.absoluteTimeInMillis();
                this.totalStats.maxLastIndexRequestTimestamp.collect(now);
                break;
            }
            case FAILURE: {
                this.postIndex(shardId, index, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf((Object)result.getResultType()));
            }
        }
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (!index.origin().isRecovery()) {
            this.totalStats.indexCurrent.dec();
            this.totalStats.indexFailed.inc();
        }
    }

    @Override
    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.inc();
        }
        return delete;
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (delete.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.deleteMetric.inc(took);
                this.totalStats.deleteCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postDelete(shardId, delete, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf((Object)result.getResultType()));
            }
        }
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.dec();
        }
    }

    void noopUpdate() {
        this.totalStats.noopUpdates.inc();
    }

    static class StatsHolder {
        private final MeanMetric indexMetric = new MeanMetric();
        private final MeanMetric deleteMetric = new MeanMetric();
        private final CounterMetric indexCurrent = new CounterMetric();
        private final CounterMetric indexFailed = new CounterMetric();
        private final CounterMetric deleteCurrent = new CounterMetric();
        private final CounterMetric noopUpdates = new CounterMetric();
        private final MaxMetric maxLastIndexRequestTimestamp = new MaxMetric();

        StatsHolder() {
        }

        IndexingStats.Stats stats(boolean isThrottled, long currentThrottleMillis) {
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.indexMetric.sum()), this.indexCurrent.count(), this.indexFailed.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count(), this.noopUpdates.count(), isThrottled, TimeUnit.MILLISECONDS.toMillis(currentThrottleMillis), new IndexingStats.Stats.DocStatusStats(), this.maxLastIndexRequestTimestamp.get());
        }
    }
}

