/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.actions.import_actions.OldConfigFileImporter;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileDialogs;
import mediathek.tool.SwingErrorDialog;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lmediathek/gui/actions/import_actions/ImportOldBlacklistAction;", "Ljavax/swing/AbstractAction;", "()V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "MediathekView"})
public final class ImportOldBlacklistAction
extends AbstractAction {
    public ImportOldBlacklistAction() {
        this.putValue("Name", "Alte Blacklist...");
        this.putValue("ShortDescription", "Erm\u00f6glicht den Import der Blacklist aus einer alten Konfigurationsdatei.");
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        MediathekGui mediathekGui = MediathekGui.ui();
        Intrinsics.checkNotNullExpressionValue(mediathekGui, "ui()");
        File selectedFile = FileDialogs.Companion.chooseLoadFileLocation(mediathekGui, " Konfigurationsdatei \u00f6ffnen", "");
        if (selectedFile != null) {
            try {
                OldConfigFileImporter configReader = new OldConfigFileImporter();
                String string = selectedFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string, "selectedFile.absolutePath");
                int foundBlacklistEntries = configReader.importAboBlacklist(string, false, true, false).component2();
                String text = "Es wurden " + foundBlacklistEntries + " Eintr\u00e4ge importiert.";
                JOptionPane.showMessageDialog(MediathekGui.ui(), text, "MediathekView", 1);
            }
            catch (Exception ex) {
                String text = "Es trat ein Fehler beim Import der Blacklist auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.";
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), text, ex);
            }
        } else {
            JOptionPane.showMessageDialog(MediathekGui.ui(), "Der Import der Blacklist wurde abgebrochen.", "MediathekView", 2);
        }
    }
}

