/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.beanvalidation;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class HibernateTraversableResolver
implements TraversableResolver {
    private final Map<Class<?>, Set<String>> associationsPerEntityClass = new HashMap();

    public void addPersister(EntityPersister persister, SessionFactoryImplementor factory) {
        Class<?> javaTypeClass = persister.getEntityMappingType().getMappedJavaType().getJavaTypeClass();
        HashSet<String> associations = new HashSet<String>();
        HibernateTraversableResolver.addAssociationsToTheSetForAllProperties(persister.getPropertyNames(), persister.getPropertyTypes(), "", factory, associations);
        this.associationsPerEntityClass.put(javaTypeClass, associations);
    }

    private static void addAssociationsToTheSetForAllProperties(String[] names, Type[] types, String prefix, SessionFactoryImplementor factory, Set<String> associations) {
        int length = names.length;
        for (int index = 0; index < length; ++index) {
            HibernateTraversableResolver.addAssociationsToTheSetForOneProperty(names[index], types[index], prefix, factory, associations);
        }
    }

    private static void addAssociationsToTheSetForOneProperty(String name, Type type, String prefix, SessionFactoryImplementor factory, Set<String> associations) {
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            HibernateTraversableResolver.addAssociationsToTheSetForOneProperty(name, collectionType.getElementType(factory), prefix, factory, associations);
        } else if (type instanceof EntityType || type instanceof AnyType) {
            associations.add(prefix + name);
        } else if (type instanceof ComponentType) {
            ComponentType componentType = (ComponentType)type;
            HibernateTraversableResolver.addAssociationsToTheSetForAllProperties(componentType.getPropertyNames(), componentType.getSubtypes(), (String)(prefix.isEmpty() ? name : prefix + name) + ".", factory, associations);
        }
    }

    private String getStringBasedPath(Path.Node traversableProperty, Path pathToTraversableObject) {
        StringBuilder path = new StringBuilder();
        for (Path.Node node : pathToTraversableObject) {
            if (node.getName() == null) continue;
            path.append(node.getName()).append('.');
        }
        if (traversableProperty.getName() == null) {
            throw new AssertionFailure("TraversableResolver being passed a traversableProperty with null name. pathToTraversableObject: " + String.valueOf(path));
        }
        path.append(traversableProperty.getName());
        return path.toString();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return Hibernate.isInitialized(traversableObject) && Hibernate.isPropertyInitialized(traversableObject, traversableProperty.getName());
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        Set<String> associations = this.associationsPerEntityClass.get(rootBeanType);
        if (associations == null) {
            return false;
        }
        return !associations.contains(this.getStringBasedPath(traversableProperty, pathToTraversableObject));
    }
}

