/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.io;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public class NioThreadPoolThreadFactory
implements ThreadFactory {
    private static final CopyOnWriteArrayList<Thread> allThreads = new CopyOnWriteArrayList();
    private static volatile ClassLoader currentCl = Thread.currentThread().getContextClassLoader();

    @Override
    public Thread newThread(final Runnable r) {
        final AtomicReference<Thread> t = new AtomicReference<Thread>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    allThreads.remove(t.get());
                }
            }
        }, "NIO IO Thread (created by Quarkus)");
        t.set(thread);
        thread.setDaemon(true);
        allThreads.add(thread);
        thread.setContextClassLoader(currentCl);
        return thread;
    }

    public static ClassLoader updateTccl(ClassLoader cl) {
        ClassLoader old = currentCl;
        currentCl = cl;
        for (Thread i : allThreads) {
            i.setContextClassLoader(cl);
        }
        return old;
    }
}

