/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToExtendsList;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToImplementsList;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToReferenceListFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J!\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/bugs/GrPermitsClauseInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "buildErrorString", "", "infos", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "intellij.groovy"})
public final class GrPermitsClauseInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            /*
             * WARNING - void declaration
             */
            public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)typeDefinition, (String)"typeDefinition");
                Iterable $this$filter$iv = SealedUtil.getAllPermittedClassElements(typeDefinition);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof PsiClass))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List permittedClassElements = (List)destination$iv$iv;
                if (!((Collection)permittedClassElements).isEmpty()) {
                    this.checkPermittedClasses(typeDefinition, permittedClassElements);
                }
            }

            public final void checkPermittedClasses(GrTypeDefinition baseClass, List<? extends PsiElement> permittedElements) {
                Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
                Intrinsics.checkNotNullParameter(permittedElements, (String)"permittedElements");
                PsiClassType ownerType = InferenceKt.type(baseClass);
                for (PsiElement psiElement : permittedElements) {
                    AddToReferenceListFix addToReferenceListFix;
                    GrReferenceList targetReferenceList;
                    GrTypeDefinition subClass;
                    Object[] objectArray = SealedHelper.INSTANCE.inferReferencedClass(psiElement);
                    if ((objectArray instanceof GrTypeDefinition ? (GrTypeDefinition)objectArray : null) == null) continue;
                    subClass = subClass;
                    if ((baseClass.isInterface() && subClass.isInterface() ? (GrReferenceList)subClass.getExtendsClause() : (baseClass.isInterface() ? (GrReferenceList)subClass.getImplementsClause() : (GrReferenceList)subClass.getExtendsClause())) == null) continue;
                    targetReferenceList = targetReferenceList;
                    PsiClassType[] psiClassTypeArray = targetReferenceList.getReferencedTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getReferencedTypes(...)");
                    if (ArraysKt.contains((Object[])psiClassTypeArray, (Object)ownerType)) continue;
                    objectArray = new Object[]{subClass.getName(), baseClass.getName()};
                    String string = GroovyBundle.message("inspection.message.invalid.permits.clause.must.directly.extend", objectArray);
                    objectArray = new LocalQuickFix[1];
                    if (targetReferenceList instanceof GrExtendsClause) {
                        String string2 = baseClass.getName();
                        if (string2 == null) {
                            string2 = "";
                        }
                        String string3 = psiElement.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                        addToReferenceListFix = new AddToExtendsList(string2, string3);
                    } else {
                        String string4 = baseClass.getName();
                        if (string4 == null) {
                            string4 = "";
                        }
                        String string5 = psiElement.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                        addToReferenceListFix = new AddToImplementsList(string4, string5);
                    }
                    objectArray[0] = addToReferenceListFix;
                    this.registerError(psiElement, string, (LocalQuickFix[])objectArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        return "";
    }
}

