/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.services.ConsoleService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.nio.file.Path;

public class PurgeIndexTask
extends Task {
    private TaintPlugin plugin;
    private Program program;

    public PurgeIndexTask(TaintPlugin plugin, Program program) {
        super("Purge Index Action", true, true, false, false);
        this.plugin = plugin;
        this.program = program;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        PluginTool tool = this.plugin.getTool();
        ConsoleService consoleService = (ConsoleService)tool.getService(ConsoleService.class);
        ToolOptions options = tool.getOptions("Decompiler");
        String facts_directory = options.getString("Taint.Directories.Facts", "/tmp/export").trim();
        String index_directory = options.getString("Taint.Directories.Output", "/tmp/output").trim();
        String index_db_name = options.getString("Taint.Query.Index", "ctadlir.db").trim();
        index_db_name = TaintOptions.makeDBName(index_db_name, this.program.getName());
        Path facts_path = Path.of(facts_directory, new String[0]);
        File facts = facts_path.toFile();
        if (facts.exists() && facts.isDirectory()) {
            File[] files;
            Msg.info((Object)((Object)this), (Object)("Deleting contents: " + facts_path.toString()));
            for (File f : files = facts.listFiles()) {
                f.delete();
            }
        }
        consoleService.addMessage("Purge Index", "using facts path: " + String.valueOf(facts_path));
        Path index_path = Path.of(index_directory, index_db_name);
        File index = index_path.toFile();
        if (index.exists() && !index.isDirectory()) {
            Msg.info((Object)((Object)this), (Object)("Deleting index: " + index_path.toString()));
            index.delete();
        }
        consoleService.addMessage("Purge Index", "using index path: " + String.valueOf(index_path));
    }
}

