/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import generic.stl.VectorSTL;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.AbstractMemoryState;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public class DefaultMemoryState
extends AbstractMemoryState {
    VectorSTL<MemoryBank> memspace = new VectorSTL();

    public DefaultMemoryState(Language language) {
        super(language);
    }

    @Override
    public final void setMemoryBank(MemoryBank bank) {
        AddressSpace spc = bank.getSpace();
        int index = spc.getUnique();
        while (index >= this.memspace.size()) {
            this.memspace.push_back(null);
        }
        this.memspace.set(index, (Object)bank);
    }

    @Override
    public final MemoryBank getMemoryBank(AddressSpace spc) {
        int index = spc.getUnique();
        if (index >= this.memspace.size()) {
            return null;
        }
        return (MemoryBank)this.memspace.get(index);
    }

    @Override
    public int getChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
        if (spc.isConstantSpace()) {
            System.arraycopy(Utils.longToBytes((long)off, (int)size, (boolean)this.language.isBigEndian()), 0, res, 0, size);
            return size;
        }
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Getting chunk from unmapped memory space: " + spc.getName());
        }
        return mspace.getChunk(off, size, res, stopOnUnintialized);
    }

    @Override
    public void setChunk(byte[] val, AddressSpace spc, long off, int size) {
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Setting chunk of unmapped memory space: " + spc.getName());
        }
        mspace.setChunk(off, size, val);
    }

    @Override
    public void setInitialized(boolean initialized, AddressSpace spc, long off, int size) {
        MemoryBank mspace = this.getMemoryBank(spc);
        if (mspace == null) {
            throw new LowlevelError("Setting intialization status of unmapped memory space: " + spc.getName());
        }
        mspace.setInitialized(off, size, initialized);
    }
}

