/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;

public class FontStretchManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 15;
    }

    @Override
    public String getPropertyName() {
        return "font-stretch";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value != null && value.getPrimitiveType() == CSSValue.Type.IDENT) {
            if (value.getIdentifierValue() == "narrower") {
                styleMap.putParentRelative(n, true);
                CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement2 == null) {
                    return ValueConstants.SEMI_CONDENSED_VALUE;
                }
                Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, string, n);
                if (value2 != null && value2.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String string2 = value2.getIdentifierValue();
                    if (string2 == "normal") {
                        return ValueConstants.SEMI_CONDENSED_VALUE;
                    }
                    if (string2 == "condensed") {
                        return ValueConstants.EXTRA_CONDENSED_VALUE;
                    }
                    if (string2 == "expanded") {
                        return ValueConstants.SEMI_EXPANDED_VALUE;
                    }
                    if (string2 == "semi-expanded") {
                        return ValueConstants.NORMAL_VALUE;
                    }
                    if (string2 == "semi-condensed") {
                        return ValueConstants.CONDENSED_VALUE;
                    }
                    if (string2 == "extra-condensed") {
                        return ValueConstants.ULTRA_CONDENSED_VALUE;
                    }
                    if (string2 == "extra-expanded") {
                        return ValueConstants.EXPANDED_VALUE;
                    }
                    if (string2 == "ultra-condensed") {
                        return ValueConstants.ULTRA_CONDENSED_VALUE;
                    }
                }
                return ValueConstants.EXTRA_EXPANDED_VALUE;
            }
            if (value.getIdentifierValue() == "wider") {
                styleMap.putParentRelative(n, true);
                CSSStylableElement cSSStylableElement3 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
                if (cSSStylableElement3 == null) {
                    return ValueConstants.SEMI_CONDENSED_VALUE;
                }
                Value value3 = cSSEngine.getComputedStyle(cSSStylableElement3, string, n);
                if (value3 != null && value3.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String string3 = value3.getIdentifierValue();
                    if (string3 == "normal") {
                        return ValueConstants.SEMI_EXPANDED_VALUE;
                    }
                    if (string3 == "condensed") {
                        return ValueConstants.SEMI_CONDENSED_VALUE;
                    }
                    if (string3 == "expanded") {
                        return ValueConstants.EXTRA_EXPANDED_VALUE;
                    }
                    if (string3 == "semi-expanded") {
                        return ValueConstants.EXPANDED_VALUE;
                    }
                    if (string3 == "semi-condensed") {
                        return ValueConstants.NORMAL_VALUE;
                    }
                    if (string3 == "extra-condensed") {
                        return ValueConstants.CONDENSED_VALUE;
                    }
                    if (string3 == "extra-expanded") {
                        return ValueConstants.ULTRA_EXPANDED_VALUE;
                    }
                    if (string3 == "ultra-condensed") {
                        return ValueConstants.EXTRA_CONDENSED_VALUE;
                    }
                }
                return ValueConstants.ULTRA_EXPANDED_VALUE;
            }
        }
        return value;
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("condensed", ValueConstants.CONDENSED_VALUE);
        values.put("expanded", ValueConstants.EXPANDED_VALUE);
        values.put("extra-condensed", ValueConstants.EXTRA_CONDENSED_VALUE);
        values.put("extra-expanded", ValueConstants.EXTRA_EXPANDED_VALUE);
        values.put("narrower", ValueConstants.NARROWER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
        values.put("semi-condensed", ValueConstants.SEMI_CONDENSED_VALUE);
        values.put("semi-expanded", ValueConstants.SEMI_EXPANDED_VALUE);
        values.put("ultra-condensed", ValueConstants.ULTRA_CONDENSED_VALUE);
        values.put("ultra-expanded", ValueConstants.ULTRA_EXPANDED_VALUE);
        values.put("wider", ValueConstants.WIDER_VALUE);
    }
}

