/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

abstract class ShorthandBuilder {
    private static final ShorthandDatabase shorthandDb = ShorthandDatabase.getInstance();
    private final String shorthandName;
    private final BaseCSSStyleDeclaration parentStyle;
    private final String[] subp;
    private final Set<String> impPtySet = new TreeSet<String>();
    private final Set<String> ptySet = new TreeSet<String>();

    ShorthandBuilder(String string, BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        this.shorthandName = string;
        this.parentStyle = baseCSSStyleDeclaration;
        this.subp = ShorthandBuilder.getShorthandDatabase().getShorthandSubproperties(string);
    }

    BaseCSSStyleDeclaration getParentStyle() {
        return this.parentStyle;
    }

    String getShorthandName() {
        return this.shorthandName;
    }

    static ShorthandDatabase getShorthandDatabase() {
        return shorthandDb;
    }

    String[] getLonghandProperties() {
        return this.getLonghandProperties(this.getShorthandName());
    }

    String[] getLonghandProperties(String string) {
        return ShorthandBuilder.getShorthandDatabase().getLonghandProperties(string);
    }

    String[] getSubproperties() {
        return this.subp;
    }

    StyleValue getCSSValue(String string) {
        return this.parentStyle.getCSSValue(string);
    }

    StyleValue getInitialPropertyValue(String string) {
        if (this.parentStyle instanceof ComputedCSSStyle) {
            return this.parentStyle.defaultPropertyValue(string);
        }
        StyleValue styleValue = PropertyDatabase.getInstance().getInitialValue(string);
        if (styleValue == null) {
            if (string.equals("color")) {
                styleValue = SystemDefaultValue.getInstance();
            } else if (string.equals("font-family")) {
                styleValue = SystemDefaultValue.getInstance();
            } else if (string.equals("text-align")) {
                String string2 = this.parentStyle.getPropertyValue("direction");
                styleValue = string2.equals("rtl") ? new IdentifierValue("right") : new IdentifierValue("left");
            } else if (string.equals("background-color")) {
                styleValue = new IdentifierValue("transparent");
            } else if (string.endsWith("-color")) {
                styleValue = new IdentifierValue("currentcolor");
            } else if (string.equals("quotes")) {
                styleValue = this.parentStyle.getValueFactory().parseProperty("\" \"");
            }
        }
        return styleValue;
    }

    boolean isPropertyAssigned(String string) {
        return this.parentStyle.isPropertySet(string);
    }

    boolean isPropertyAssigned(String string, boolean bl) {
        return this.parentStyle.isPropertySet(string, bl);
    }

    boolean isPropertyInAnySet(String string) {
        return this.ptySet.contains(string) || this.impPtySet.contains(string);
    }

    boolean isPropertyInImportantSet(String string) {
        return this.impPtySet.contains(string);
    }

    void addAssignedProperty(String string, boolean bl) {
        if (bl) {
            this.impPtySet.add(string);
        } else {
            this.ptySet.add(string);
        }
    }

    boolean removeAssignedProperty(String string) {
        return this.ptySet.remove(string) || this.impPtySet.remove(string);
    }

    public void appendMinifiedCssText(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        switch (this.appendShorthandText(stringBuilder)) {
            case 1: {
                stringBuilder.setLength(n);
            }
            case 2: {
                this.appendMinifiedIndividualProperties(stringBuilder);
            }
        }
    }

    protected void appendMinifiedIndividualProperties(StringBuilder stringBuilder) {
        this.appendPropertiesInSet(stringBuilder, this.impPtySet, true);
        this.appendPropertiesInSet(stringBuilder, this.ptySet, false);
    }

    void appendPropertiesInSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        int n = stringBuilder.length();
        for (String string : set) {
            StyleValue styleValue = this.getCSSValue(string);
            if (styleValue.getPrimitiveType() != CSSValue.Type.INTERNAL) {
                stringBuilder.append(string).append(':');
                BaseCSSStyleDeclaration.appendMinifiedCssText(bufferSimpleWriter, declarationFormattingContext, styleValue, string);
                this.appendPriority(stringBuilder, bl);
                continue;
            }
            stringBuilder.setLength(n);
            this.appendPropertiesWithInternal(bufferSimpleWriter, declarationFormattingContext, set, bl);
            break;
        }
    }

    private void appendPropertiesWithInternal(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, Set<String> set, boolean bl) {
        StyleValue styleValue;
        StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>(set.size() - 1);
        for (String string : set) {
            styleValue = this.getCSSValue(string);
            if (styleValue.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                String string2 = ((PendingValue)styleValue).getShorthandName();
                if (!hashSet.add(string2) || !string2.equals(this.getShorthandName()) && !this.isResponsibleShorthand(string2)) continue;
                ShorthandValue shorthandValue = (ShorthandValue)this.getCSSValue(string2);
                this.parentStyle.appendShorthandMinifiedCssText(stringBuilder, string2, shorthandValue);
                continue;
            }
            hashSet2.add(string);
        }
        for (String string : hashSet2) {
            styleValue = this.getCSSValue(string);
            stringBuilder.append(string).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(bufferSimpleWriter, declarationFormattingContext, styleValue, string);
            this.appendPriority(stringBuilder, bl);
        }
    }

    protected boolean isResponsibleShorthand(String string) {
        return true;
    }

    int appendShorthandText(StringBuilder stringBuilder) {
        this.preprocessSet();
        int n = this.getMinimumSetSize();
        if (this.getTotalSetSize() < n) {
            return 1;
        }
        return this.processPriorities(stringBuilder);
    }

    protected void preprocessSet() {
    }

    protected int getTotalSetSize() {
        return this.impPtySet.size() + this.ptySet.size();
    }

    boolean hasPropertiesToExclude(Set<String> set) {
        for (String string : set) {
            if (!this.isPropertyToExclude(string)) continue;
            return true;
        }
        return false;
    }

    boolean isPropertyToExclude(String string) {
        return this.isExcludedValue(this.getCSSValue(string));
    }

    boolean isExcludedValue(StyleValue styleValue) {
        if (styleValue.isPrimitiveValue()) {
            return this.isExcludedType(styleValue.getPrimitiveType());
        }
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            CSSValueList cSSValueList = (CSSValueList)((Object)styleValue);
            for (StyleValue styleValue2 : cSSValueList) {
                if (!this.isExcludedValue(styleValue2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isExcludedType(CSSValue.Type type) {
        return type == CSSValue.Type.LEXICAL;
    }

    int processPriorities(StringBuilder stringBuilder) {
        int n = this.getMinimumSetSize();
        int n2 = this.impPtySet.size();
        if (n2 < n) {
            int n3 = this.appendShorthandSet(stringBuilder, this.ptySet, false);
            if (n3 != 0) {
                return n3;
            }
            if (n2 != 0) {
                this.appendPropertiesInSet(stringBuilder, this.impPtySet, true);
            }
        } else {
            if (this.ptySet.size() != 0) {
                int n4 = stringBuilder.length();
                int n5 = this.appendShorthandSet(stringBuilder, this.ptySet, false);
                switch (n5) {
                    case 0: {
                        this.ptySet.clear();
                        break;
                    }
                    case 1: {
                        stringBuilder.setLength(n4);
                        this.appendPropertiesInSet(stringBuilder, this.ptySet, false);
                    }
                }
            }
            return this.appendShorthandSet(stringBuilder, this.impPtySet, true);
        }
        return 0;
    }

    byte checkValuesForInherit(Set<String> set) {
        return this.checkValuesForInherit(this.getShorthandName(), set);
    }

    byte checkValuesForInherit(String string, Set<String> set) {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray = this.getLonghandProperties(string)) {
            if (!set.contains(string2)) continue;
            n2 = (byte)(n2 + 1);
            if (!this.isInherit(this.getCSSValue(string2))) continue;
            n = (byte)(n + 1);
        }
        if (n == 0) {
            return 0;
        }
        if (n == n2) {
            return 1;
        }
        return 2;
    }

    byte checkDeclaredValuesForInherit(Set<String> set) {
        byte by = 0;
        for (String string : set) {
            if (!this.isInherit(this.getCSSValue(string))) continue;
            by = (byte)(by + 1);
        }
        if (by == 0) {
            return 0;
        }
        if (by == (byte)set.size()) {
            return 1;
        }
        return 2;
    }

    boolean isInherit(StyleValue styleValue) {
        return styleValue != null && styleValue.getPrimitiveType() == CSSValue.Type.INHERIT;
    }

    byte checkDeclaredValuesForKeyword(CSSValue.Type type, Set<String> set) {
        byte by = 0;
        for (String string : set) {
            StyleValue styleValue = this.getCSSValue(string);
            if (type != styleValue.getPrimitiveType()) continue;
            by = (byte)(by + 1);
        }
        if (by == 0) {
            return 0;
        }
        if (by == (byte)set.size()) {
            return 1;
        }
        return 2;
    }

    byte checkValuesForType(CSSValue.Type type, boolean bl) {
        Set<String> set = bl ? this.impPtySet : this.ptySet;
        return this.checkValuesForType(type, this.getShorthandName(), set);
    }

    byte checkValuesForType(CSSValue.Type type, Set<String> set) {
        return this.checkValuesForType(type, this.getShorthandName(), set);
    }

    byte checkValuesForType(CSSValue.Type type, String string, Set<String> set) {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray = this.getLonghandProperties(string)) {
            if (!set.contains(string2)) continue;
            n2 = (byte)(n2 + 1);
            StyleValue styleValue = this.getCSSValue(string2);
            if (styleValue.getPrimitiveType() != type) continue;
            n = (byte)(n + 1);
        }
        if (n == 0) {
            return 0;
        }
        if (n == n2) {
            return 1;
        }
        return 2;
    }

    boolean isValueOfType(CSSValue.Type type, String string) {
        StyleValue styleValue = this.getCSSValue(string);
        return styleValue != null && styleValue.getPrimitiveType() == type;
    }

    static boolean isCssValueOfType(CSSValue.Type type, StyleValue styleValue) {
        return styleValue != null && styleValue.getPrimitiveType() == type;
    }

    String getValueTextIfNotInitial(String string, StyleValue styleValue) {
        if (styleValue != null && !styleValue.isSystemDefault() && styleValue.getPrimitiveType() != CSSValue.Type.INITIAL && !this.valueEquals(this.getInitialPropertyValue(string), styleValue)) {
            return styleValue.getMinifiedCssText(string);
        }
        return null;
    }

    boolean isInitialValue(String string) {
        StyleValue styleValue = this.getCSSValue(string);
        return styleValue.isSystemDefault() || this.isEffectiveInitialKeyword(styleValue) || this.valueEquals(this.getInitialPropertyValue(string), styleValue);
    }

    protected boolean isNotInitialValue(StyleValue styleValue, String string) {
        return styleValue != null && !styleValue.isSystemDefault() && !this.isEffectiveInitialKeyword(styleValue) && !this.valueEquals(this.getInitialPropertyValue(string), styleValue);
    }

    boolean isEffectiveInitialKeyword(StyleValue styleValue) {
        CSSValue.Type type = styleValue.getPrimitiveType();
        return type == CSSValue.Type.INITIAL || !this.isInheritedProperty() && type == CSSValue.Type.UNSET;
    }

    boolean isInheritedProperty() {
        return false;
    }

    static boolean containsControl(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return true;
        }
        return false;
    }

    static boolean isIdentOrKeyword(StyleValue styleValue) {
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            for (StyleValue styleValue2 : valueList) {
                if (styleValue2.getPrimitiveType() == CSSValue.Type.IDENT) continue;
                return false;
            }
            return true;
        }
        return styleValue.getPrimitiveType() == CSSValue.Type.IDENT || styleValue.getCssValueType() == CSSValue.CssType.KEYWORD;
    }

    static boolean isUnknownIdentifier(String string, StyleValue styleValue) {
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            String string2;
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && !"none".equalsIgnoreCase(string2 = cSSTypedValue.getStringValue())) {
                return !ShorthandBuilder.getShorthandDatabase().isIdentifierValue(string, string2);
            }
        } else if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            int n = valueList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!ShorthandBuilder.isUnknownIdentifier(string, valueList.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isImagePrimitiveValue(TypedValue typedValue) {
        CSSValue.Type type = typedValue.getPrimitiveType();
        return type == CSSValue.Type.URI || type == CSSValue.Type.SRC || type == CSSValue.Type.GRADIENT || type == CSSValue.Type.FUNCTION && ShorthandBuilder.isImageFunction(typedValue) || type == CSSValue.Type.ELEMENT_REFERENCE;
    }

    private static boolean isImageFunction(TypedValue typedValue) {
        String string = typedValue.getStringValue();
        return "image".equalsIgnoreCase(string) || "image-set".equalsIgnoreCase(string) || "cross-fade".equalsIgnoreCase(string);
    }

    boolean valueEquals(StyleValue styleValue, StyleValue styleValue2) {
        if (styleValue2 == null) {
            return styleValue == null;
        }
        if (styleValue == null) {
            return false;
        }
        if (styleValue2.isSystemDefault() != styleValue.isSystemDefault()) {
            return false;
        }
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED && styleValue2.getCssValueType() == CSSValue.CssType.TYPED) {
            TypedValue typedValue = (TypedValue)styleValue;
            CSSValue.Type type = typedValue.getPrimitiveType();
            TypedValue typedValue2 = (TypedValue)styleValue2;
            CSSValue.Type type2 = typedValue2.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                if (type2 == CSSValue.Type.COLOR) {
                    return this.testColorIdentifier(typedValue2, typedValue.getStringValue().toLowerCase(Locale.ROOT));
                }
                if (type2 == CSSValue.Type.IDENT) {
                    return typedValue.getStringValue().equalsIgnoreCase(typedValue2.getStringValue());
                }
            } else if (type == CSSValue.Type.COLOR && type2 == CSSValue.Type.IDENT) {
                return this.testColorIdentifier(typedValue, typedValue2.getStringValue());
            }
        }
        return styleValue.equals(styleValue2);
    }

    private boolean testColorIdentifier(TypedValue typedValue, String string) {
        String string2 = "transparent".equals(string) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(string);
        if (string2 != null) {
            ValueFactory valueFactory = new ValueFactory();
            try {
                CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)valueFactory.parseProperty(string2));
                return cSSTypedValue.toRGBColor().equals(typedValue.toRGBColor());
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean appendValueIfNotInitial(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, String string, boolean bl) {
        StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
        StyleValue styleValue = this.getCSSValue(string);
        if (this.isNotInitialValue(styleValue, string)) {
            if (bl) {
                stringBuilder.append(' ');
            }
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, string, styleValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return bl;
    }

    boolean appendDeclarationIfNotInitial(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, String string, boolean bl) {
        StyleValue styleValue = this.getCSSValue(string);
        boolean bl2 = "important".equalsIgnoreCase(this.parentStyle.getPropertyPriority(string));
        if (this.isNotInitialValue(styleValue, string) && bl2 == bl) {
            StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
            stringBuilder.append(string).append(':');
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, string, styleValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl2) {
                stringBuilder.append('!').append("important");
            }
            stringBuilder.append(';');
            return true;
        }
        return false;
    }

    boolean appendDeclarationIfNotKeyword(CSSValue.Type type, BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, String string, boolean bl) {
        StyleValue styleValue = this.getCSSValue(string);
        boolean bl2 = "important".equalsIgnoreCase(this.parentStyle.getPropertyPriority(string));
        if (!ShorthandBuilder.isCssValueOfType(type, styleValue) && bl2 == bl) {
            StringBuilder stringBuilder = bufferSimpleWriter.getBuffer();
            stringBuilder.append(string).append(':');
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, string, styleValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl2) {
                stringBuilder.append('!').append("important");
            }
            stringBuilder.append(';');
            return true;
        }
        return false;
    }

    void appendPriority(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append("!important;");
        } else {
            stringBuilder.append(';');
        }
    }

    boolean appendImage(StringBuilder stringBuilder, boolean bl, StyleValue styleValue) {
        String string;
        StringBuilder stringBuilder2 = new StringBuilder(64);
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder2);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            CSSValue.Type type = cSSTypedValue.getPrimitiveType();
            if (type == CSSValue.Type.URI) {
                URL uRL = ((URIValue)cSSTypedValue).getURLValue();
                if (uRL != null) {
                    String string2 = this.getBaseURI();
                    string = string2 != null ? ShorthandBuilder.relativeURI(string2, uRL) : uRL.toExternalForm();
                    string = "url('" + string + "')";
                } else {
                    try {
                        declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, "background-image", styleValue);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    string = stringBuilder2.toString();
                }
            } else if (type == CSSValue.Type.IDENT) {
                string = cSSTypedValue.getStringValue();
                if ("none".equalsIgnoreCase(string)) {
                    return false;
                }
            } else {
                try {
                    declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, "background-image", styleValue);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string = stringBuilder2.toString();
            }
        } else {
            if (cssType == CSSValue.CssType.KEYWORD) {
                return false;
            }
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, "background-image", styleValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = stringBuilder2.toString();
        }
        if (bl) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        return true;
    }

    String getBaseURI() {
        Document document;
        Object object;
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.getParentStyle().getParentRule();
        if (baseCSSDeclarationRule != null && (object = baseCSSDeclarationRule.getParentStyleSheet()) != null) {
            return object.getHref();
        }
        object = this.getParentStyle().getOwnerNode();
        String string = null;
        if (object != null && (document = object.getOwnerDocument()) != null) {
            string = document.getBaseURI();
        }
        return string;
    }

    static String relativeURI(String string, URL uRL) {
        try {
            URL uRL2 = new URL(string);
            if (ShorthandBuilder.sameTree(uRL2, uRL)) {
                try {
                    return uRL2.toURI().relativize(uRL.toURI()).toString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string2 = uRL.toExternalForm();
        return string2;
    }

    static boolean sameTree(URL uRL, URL uRL2) {
        if (uRL.getProtocol().equals(uRL2.getProtocol())) {
            String string = uRL.getHost();
            String string2 = uRL2.getHost();
            if (string != null) {
                if (string.equals(string2)) {
                    int n = uRL.getPort();
                    int n2 = uRL2.getPort();
                    if (n == -1) {
                        n = uRL.getDefaultPort();
                    }
                    if (n2 == -1) {
                        n2 = uRL2.getDefaultPort();
                    }
                    return n == n2;
                }
            } else {
                return string2 == null;
            }
        }
        return false;
    }

    protected int getMinimumSetSize() {
        return this.getLonghandProperties().length;
    }

    abstract int appendShorthandSet(StringBuilder var1, Set<String> var2, boolean var3);
}

