# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## CoRankMorphism
InstallMethod( AddCoRankMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoRankMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoRankMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoRankMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoTraceMap
InstallMethod( AddCoTraceMap,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoTraceMap", category, func, -1 );
    
end );

InstallMethod( AddCoTraceMap,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoTraceMap", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedCoevaluationForCoDual
InstallMethod( AddCoclosedCoevaluationForCoDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedCoevaluationForCoDual", category, func, -1 );
    
end );

InstallMethod( AddCoclosedCoevaluationForCoDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedCoevaluationForCoDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoclosedCoevaluationForCoDualWithGivenTensorProduct
InstallMethod( AddCoclosedCoevaluationForCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoclosedCoevaluationForCoDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddCoclosedCoevaluationForCoDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoclosedCoevaluationForCoDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoclosedCoevaluationForCoDualWithGivenTensorProduct,
                    "CoclosedCoevaluationForCoDualWithGivenTensorProduct by calling CoclosedCoevaluationForCoDual with the WithGiven argument(s) dropped",
                    [
                        [ CoclosedCoevaluationForCoDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return CoclosedCoevaluationForCoDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoclosedCoevaluationForCoDual,
                    "CoclosedCoevaluationForCoDual by calling CoclosedCoevaluationForCoDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ CoclosedCoevaluationForCoDualWithGivenTensorProduct, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ CoDualOnObjects, 1 ],
                        [ TensorUnit, 1 ],
                    ],
  function( cat, a )
    
    return CoclosedCoevaluationForCoDualWithGivenTensorProduct( cat, TensorProductOnObjects( cat, a, CoDualOnObjects( cat, a ) ), a, TensorUnit( cat ) );
    
end : is_with_given_derivation := true );

## InternalCoHomTensorProductCompatibilityMorphismInverse
InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismInverse,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismInverse", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismInverse,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismInverse", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects
InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects,
                    "InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects by calling InternalCoHomTensorProductCompatibilityMorphismInverse with the WithGiven argument(s) dropped",
                    [
                        [ InternalCoHomTensorProductCompatibilityMorphismInverse, 1 ],
                    ],
  function( cat, source, list, range )
    
    return InternalCoHomTensorProductCompatibilityMorphismInverse( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InternalCoHomTensorProductCompatibilityMorphismInverse,
                    "InternalCoHomTensorProductCompatibilityMorphismInverse by calling InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 3 ],
                        [ InternalCoHomOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return InternalCoHomTensorProductCompatibilityMorphismInverseWithGivenObjects( cat, TensorProductOnObjects( cat, InternalCoHomOnObjects( cat, list[1], list[3] ), InternalCoHomOnObjects( cat, list[2], list[4] ) ), list, InternalCoHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[2] ), TensorProductOnObjects( cat, list[3], list[4] ) ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromInternalCoHomToTensorProductWithCoDualObject
InstallMethod( AddIsomorphismFromInternalCoHomToTensorProductWithCoDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalCoHomToTensorProductWithCoDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalCoHomToTensorProductWithCoDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalCoHomToTensorProductWithCoDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromTensorProductWithCoDualObjectToInternalCoHom
InstallMethod( AddIsomorphismFromTensorProductWithCoDualObjectToInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromTensorProductWithCoDualObjectToInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromTensorProductWithCoDualObjectToInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromTensorProductWithCoDualObjectToInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromTensorProductToInternalCoHom
InstallMethod( AddMorphismFromTensorProductToInternalCoHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToInternalCoHom", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToInternalCoHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToInternalCoHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromTensorProductToInternalCoHomWithGivenObjects
InstallMethod( AddMorphismFromTensorProductToInternalCoHomWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromTensorProductToInternalCoHomWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromTensorProductToInternalCoHomWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromTensorProductToInternalCoHomWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromTensorProductToInternalCoHomWithGivenObjects,
                    "MorphismFromTensorProductToInternalCoHomWithGivenObjects by calling MorphismFromTensorProductToInternalCoHom with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromTensorProductToInternalCoHom, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromTensorProductToInternalCoHom( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromTensorProductToInternalCoHom,
                    "MorphismFromTensorProductToInternalCoHom by calling MorphismFromTensorProductToInternalCoHomWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromTensorProductToInternalCoHomWithGivenObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ CoDualOnObjects, 1 ],
                        [ InternalCoHomOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromTensorProductToInternalCoHomWithGivenObjects( cat, TensorProductOnObjects( cat, CoDualOnObjects( cat, a ), b  ), a, b, InternalCoHomOnObjects( cat, b, a ) );
    
end : is_with_given_derivation := true );

## MorphismToCoBidual
InstallMethod( AddMorphismToCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismToCoBidualWithGivenCoBidual
InstallMethod( AddMorphismToCoBidualWithGivenCoBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismToCoBidualWithGivenCoBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismToCoBidualWithGivenCoBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismToCoBidualWithGivenCoBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismToCoBidualWithGivenCoBidual,
                    "MorphismToCoBidualWithGivenCoBidual by calling MorphismToCoBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismToCoBidual, 1 ],
                    ],
  function( cat, a, r )
    
    return MorphismToCoBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismToCoBidual,
                    "MorphismToCoBidual by calling MorphismToCoBidualWithGivenCoBidual with the WithGiven object(s)",
                    [
                        [ MorphismToCoBidualWithGivenCoBidual, 1 ],
                        [ CoDualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismToCoBidualWithGivenCoBidual( cat, a, CoDualOnObjects( cat, CoDualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );
