# LINS, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("lins02.tst");

# doc/lins_interface.xml:96-99
gap> G := DihedralGroup(50);
<pc group of size 50 with 3 generators>

# doc/lins_interface.xml:104-117
gap> gr := LowIndexNormalSubgroupsSearchForAll(G, 50);
<lins graph contains 4 normal subgroups up to index 50>
gap> r := LinsRoot(gr);
<lins node of index 1>
gap> H := Grp(r);
<fp group of size 50 on the generators [ F1, F2, F3 ]>
gap> Iso := IsomorphismFpGroup(gr);
[ f1, f2, f3 ] -> [ F1, F2, F3 ]
gap> Source(Iso) = G;
true
gap> Range(Iso) = H;
true

# doc/lins_interface.xml:122-128
gap> L := List(gr);
[ <lins node of index 1>, <lins node of index 2>, <lins node of index 10>, 
  <lins node of index 50> ]
gap> IsoTypes := List(L, node -> StructureDescription(Grp(node)));
[ "D50", "C25", "C5", "1" ]

# doc/lins_interface.xml:137-140
gap> G := ElementaryAbelianGroup(5^4);
<pc group of size 625 with 4 generators>

# doc/lins_interface.xml:144-147
gap> gr := LowIndexNormalSubgroupsSearchForIndex(G, 5 ^ 2, infinity);
<lins graph contains 963 normal subgroups up to index 25>

# doc/lins_interface.xml:167-171
gap> L := ComputedNormalSubgroups(gr);;
gap> IsoTypes := Collected(List(L, node -> StructureDescription(Grp(node))));
[ [ "C5 x C5", 806 ] ]

# doc/lins_interface.xml:181-186
gap> G := AbelianGroup([3, 3, 4, 5]);
<pc group of size 180 with 4 generators>
gap> gr := LowIndexNormalSubgroupsSearchForIndex(G, 15, 1);
<lins graph contains 7 normal subgroups up to index 15>

# doc/lins_interface.xml:190-195
gap> L := ComputedNormalSubgroups(gr);
[ <lins node of index 15> ]
gap> IsoTypes := List(L, node -> StructureDescription(Grp(node)));
[ "C12" ]

#
gap> STOP_TEST("lins02.tst", 1);
