/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.mindmapmode.MapLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.MapProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class LoaderProxy
implements Proxy.Loader {
    private final ScriptContext scriptContext;
    private final MapLoader mapLoader;
    Pattern MAP_CONTENT_BEGIN = Pattern.compile("^\\s*<");

    static Proxy.Loader of(ScriptContext scriptContext) {
        return new LoaderProxy(scriptContext);
    }

    static Proxy.Loader of(File file, ScriptContext scriptContext) {
        return new LoaderProxy(scriptContext).load(file);
    }

    static Proxy.Loader of(URL url, ScriptContext scriptContext) {
        return new LoaderProxy(scriptContext).load(url);
    }

    static Proxy.Loader of(String fileOrContent, ScriptContext scriptContext) {
        return new LoaderProxy(scriptContext).load(fileOrContent);
    }

    static Proxy.Loader of(InputStream inputStream, ScriptContext scriptContext) {
        return new LoaderProxy(scriptContext).load(inputStream);
    }

    LoaderProxy(ScriptContext scriptContext) {
        this.mapLoader = new MapLoader((ModeController)MModeController.getMModeController());
        this.scriptContext = scriptContext;
    }

    private LoaderProxy load(File file) {
        if (file.isAbsolute() || this.scriptContext == null) {
            this.mapLoader.load(file);
        } else {
            this.load(file.getPath().replace('\\', '/'));
        }
        return this;
    }

    private LoaderProxy load(URL url) {
        this.mapLoader.load(url);
        return this;
    }

    private LoaderProxy load(String filePathOrContent) {
        if (this.containsMindMapContent(filePathOrContent)) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(filePathOrContent.getBytes());
            this.load(inputStream);
        } else {
            this.mapLoader.load(this.provideScriptContext().toUrl(filePathOrContent));
        }
        return this;
    }

    private LoaderProxy load(InputStream inputStream) {
        this.mapLoader.setInputStream(inputStream);
        return this;
    }

    private boolean containsMindMapContent(String filePathOrContent) {
        return this.MAP_CONTENT_BEGIN.matcher(filePathOrContent).find();
    }

    private ScriptContext provideScriptContext() {
        return this.scriptContext != null ? this.scriptContext : new ScriptContext(null);
    }

    public LoaderProxy newMapLocation(final File file) {
        File absoluteFile = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return LoaderProxy.this.provideScriptContext().toAbsoluteFile(file);
            }
        });
        this.mapLoader.newMapLocation(absoluteFile);
        return this;
    }

    public LoaderProxy unsetMapLocation() {
        this.mapLoader.unsetMapLocation();
        return this;
    }

    public LoaderProxy newMapLocation(String file) {
        this.mapLoader.newMapLocation(new File(file));
        return this;
    }

    public LoaderProxy saveAfterLoading() {
        this.mapLoader.saveAfterLoading();
        return this;
    }

    public LoaderProxy selectNodeById(String nodeId) {
        this.mapLoader.selectNodeById(nodeId);
        return this;
    }

    public LoaderProxy withView() {
        this.mapLoader.withView();
        return this;
    }

    @Override
    public Proxy.MindMap getMindMap() {
        MapModel newMap = this.mapLoader.getMap();
        return new MapProxy(newMap, this.scriptContext);
    }
}

