/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NodeList;

class NodeListWithReminders
extends NodeList {
    NodeListWithReminders(String windowTitle, boolean searchInAllMaps, String windowPreferenceStorageProperty) {
        super(windowTitle, searchInAllMaps, windowPreferenceStorageProperty);
    }

    @Override
    protected void createSpecificButtons(Container container) {
        Component[] components;
        AbstractAction runAllAction = new AbstractAction(TextUtils.getText((String)"reminder.Run_All")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReminders.this.runScripts(false);
            }
        };
        JButton runAllButton = new JButton(runAllAction);
        final AbstractAction runSelectedAction = new AbstractAction(TextUtils.getText((String)"reminder.Run_Selected")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReminders.this.runScripts(true);
            }
        };
        JButton runSelectedButton = new JButton(runSelectedAction);
        runSelectedAction.setEnabled(false);
        AbstractAction removeAllAction = new AbstractAction(TextUtils.getText((String)"reminder.Remove_All")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReminders.this.removeReminders(false);
                NodeListWithReminders.this.disposeDialog();
            }
        };
        JButton removeAllButton = new JButton(removeAllAction);
        final AbstractAction removeSelectedAction = new AbstractAction(TextUtils.getText((String)"reminder.Remove_Selected")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReminders.this.removeReminders(true);
            }
        };
        JButton removeSelectedButton = new JButton(removeSelectedAction);
        removeSelectedAction.setEnabled(false);
        ListSelectionModel rowSM1 = this.tableView.getSelectionModel();
        rowSM1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                runSelectedAction.setEnabled(enable);
                removeSelectedAction.setEnabled(enable);
            }
        });
        for (Component c : components = new Component[]{runAllButton, runSelectedButton, removeAllButton, removeSelectedButton}) {
            container.add(c);
        }
    }

    private void runScripts(boolean selectedOnly) {
        this.apply(selectedOnly, this::runScript);
    }

    private void runScript(ReminderHook c, NodeModel n, ReminderExtension r, int row) {
        r.runScript();
    }

    private void removeReminders(boolean selectedOnly) {
        this.apply(selectedOnly, this::removeReminder);
    }

    private void removeReminder(ReminderHook reminderHook, NodeModel node, ReminderExtension reminder, int row) {
        reminderHook.undoableDeactivateHook(node);
        this.tableView.setValueAt(null, row, this.nodeReminderColumn);
    }

    private void apply(boolean selectedOnly, ReminderAction action) {
        ReminderHook reminderController = (ReminderHook)Controller.getCurrentModeController().getExtension(ReminderHook.class);
        for (int row = 0; row < this.tableView.getRowCount(); ++row) {
            NodeModel node;
            ReminderExtension reminder;
            if (selectedOnly && !this.tableView.isRowSelected(row) || (reminder = (ReminderExtension)(node = this.getMindMapNode(row)).getExtension(ReminderExtension.class)) == null) continue;
            action.apply(reminderController, node, reminder, row);
        }
    }

    private static interface ReminderAction {
        public void apply(ReminderHook var1, NodeModel var2, ReminderExtension var3, int var4);
    }
}

