/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import com.jgoodies.forms.builder.FormBuilder;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.view.swing.features.filepreview.MindMapPreviewWithOptions;

public class ManageAssociatedMindMapsDialog {
    private final MapModel map;
    private final JDialog dialog;
    private URI followedMapLocation;
    private URI associatedMapLocation;
    private final JButton[] followedMapButtons;
    private final JButton[] associatedMapButtons;

    public ManageAssociatedMindMapsDialog(String title, MapModel map) {
        this.map = map;
        Frame owner = UITools.getCurrentFrame();
        this.dialog = new JDialog(owner);
        FormBuilder formBuilder = FormBuilder.create().columns("p, 3dlu, fill:3dlu:grow, 3dlu, p", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]);
        formBuilder.add(TextUtils.getText((String)"followed_map"), new Object[0]).xy(1, 1);
        JTextArea followedMapField = new JTextArea();
        followedMapField.setColumns(80);
        followedMapField.setLineWrap(true);
        followedMapField.setWrapStyleWord(false);
        formBuilder.add((Component)followedMapField).xy(3, 1);
        JButton changeFollowedMapButton = this.createChangeMapButton("followedTemplateLocation", "select_followed_map", followedMapField);
        formBuilder.add((Component)changeFollowedMapButton).xy(5, 1);
        JButton openFollowedMapButton = this.createOpenButton(() -> this.followedMapLocation);
        JButton copyStylesFromFollowedMapButton = this.createCopyStylesButton(() -> this.followedMapLocation);
        JButton replaceStylesFromFollowedMapButton = this.createReplaceStylesButton(() -> this.followedMapLocation);
        JButton unfolowButton = this.createUnfollowButton(followedMapField);
        this.followedMapButtons = new JButton[]{openFollowedMapButton, copyStylesFromFollowedMapButton, replaceStylesFromFollowedMapButton, unfolowButton};
        formBuilder.addBar(new JButton[]{openFollowedMapButton, copyStylesFromFollowedMapButton, replaceStylesFromFollowedMapButton, unfolowButton}).xyw(1, 3, 5);
        formBuilder.add(TextUtils.getText((String)"associated_template"), new Object[0]).xy(1, 5);
        JTextArea associatedMapField = new JTextArea();
        associatedMapField.setColumns(80);
        associatedMapField.setLineWrap(true);
        associatedMapField.setWrapStyleWord(false);
        formBuilder.add((Component)associatedMapField).xy(3, 5);
        JButton changeAssosiatedMapButton = this.createChangeMapButton("associatedTemplateLocation", "select_associated_template", associatedMapField);
        formBuilder.add((Component)changeAssosiatedMapButton).xy(5, 5);
        JButton openAssociatedMapButton = this.createOpenButton(() -> this.associatedMapLocation);
        JButton copyStylesFromAssociatedMapButton = this.createCopyStylesButton(() -> this.associatedMapLocation);
        JButton replaceStylesFromAssociatedMapButton = this.createReplaceStylesButton(() -> this.associatedMapLocation);
        this.associatedMapButtons = new JButton[]{openAssociatedMapButton, copyStylesFromAssociatedMapButton, replaceStylesFromAssociatedMapButton};
        formBuilder.addBar(new JButton[]{openAssociatedMapButton, copyStylesFromAssociatedMapButton, replaceStylesFromAssociatedMapButton}).xyw(1, 7, 5);
        JButton closeButton = this.createCloseMapButton();
        formBuilder.add((Component)closeButton).xy(1, 9, "l,c");
        this.updateAssociatedMap("followedTemplateLocation", followedMapField, TextUtils.getText((String)"no_map_followed"));
        this.updateAssociatedMap("associatedTemplateLocation", associatedMapField, TextUtils.getText((String)"no_template_associated"));
        this.dialog.setModal(true);
        this.dialog.setTitle(title);
        this.dialog.getContentPane().add(formBuilder.build());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(owner);
    }

    private JButton createUnfollowButton(JTextArea followedMapField) {
        JButton unfolowButton = new JButton(TextUtils.getText((String)"unfollow"));
        unfolowButton.setEnabled(this.followedMapLocation != null);
        unfolowButton.addActionListener(e -> {
            MapStyle.getController().setProperty(this.map, "followedTemplateLocation", null);
            MapStyle.getController().setProperty(this.map, "followedMapLastTime", null);
            followedMapField.setText(TextUtils.getText((String)"no_map_followed"));
            this.enableButtons(this.followedMapButtons, false);
        });
        return unfolowButton;
    }

    private JButton createCloseMapButton() {
        JButton closeButton = new JButton(TextUtils.getText((String)"close"));
        closeButton.addActionListener(e -> this.dialog.setVisible(false));
        return closeButton;
    }

    private JButton createReplaceStylesButton(Supplier<URI> sourceLocation) {
        JButton replaceStylesFromFollowedMapButton = new JButton(TextUtils.getText((String)"replaceStyles"));
        replaceStylesFromFollowedMapButton.addActionListener(e -> {
            try {
                MapStyle.getController().replaceStyles((URI)sourceLocation.get(), this.map, false, false);
                this.dialog.setVisible(false);
            }
            catch (MalformedURLException ex) {
                LogUtils.warn((Throwable)ex);
            }
        });
        return replaceStylesFromFollowedMapButton;
    }

    private JButton createCopyStylesButton(Supplier<URI> sourceLocation) {
        JButton copyStylesFromFollowedMapButton = new JButton(TextUtils.getText((String)"copyStyles"));
        copyStylesFromFollowedMapButton.addActionListener(e -> {
            try {
                MapStyle.getController().copyStyles((URI)sourceLocation.get(), this.map, false, false);
                this.dialog.setVisible(false);
            }
            catch (MalformedURLException ex) {
                LogUtils.warn((Throwable)ex);
            }
        });
        return copyStylesFromFollowedMapButton;
    }

    private JButton createOpenButton(Supplier<URI> mapLocation) {
        JButton openFollowedMapButton = new JButton(TextUtils.getText((String)"open"));
        openFollowedMapButton.addActionListener(e -> {
            UrlManager.getController().loadHyperlink(new Hyperlink((URI)mapLocation.get()));
            this.dialog.setVisible(false);
        });
        return openFollowedMapButton;
    }

    private JButton createChangeMapButton(String mapProperty, String fileChooserTitleProperty, JTextArea field) {
        JButton assignMapButton = new JButton(TextUtils.getText((String)"OptionPanel.set_property_text"));
        assignMapButton.addActionListener(e -> {
            MindMapPreviewWithOptions previewWithOptions = MindMapPreviewWithOptions.createFileOpenDialogAndOptions((String)TextUtils.getText((String)fileChooserTitleProperty));
            JFileChooser fileChooser = previewWithOptions.getFileChooser();
            int returnVal = fileChooser.showOpenDialog((Component)UITools.getCurrentFrame());
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (!file.exists()) {
                return;
            }
            MapStyle.getController().setProperty(this.map, mapProperty, TemplateManager.INSTANCE.normalizeTemplateLocation(file.toURI()).toString());
            this.updateAssociatedMap(mapProperty, field, TextUtils.getText((String)"no_map_followed"));
        });
        return assignMapButton;
    }

    private void updateAssociatedMap(String propertyName, JTextArea mapField, String noMapMessage) {
        String followedMap = MapStyle.getController().getProperty(this.map, propertyName);
        mapField.setEditable(false);
        URI uri = null;
        if (followedMap != null) {
            try {
                uri = new URI(followedMap);
                String message = TemplateManager.INSTANCE.describeNormalizedLocation(uri);
                mapField.setText(message);
                uri = TemplateManager.INSTANCE.expandTemplateLocation(uri);
            }
            catch (URISyntaxException e) {
                LogUtils.severe((Throwable)e);
            }
        } else {
            mapField.setText(noMapMessage);
        }
        if ("followedTemplateLocation".equals(propertyName)) {
            this.followedMapLocation = uri;
            this.enableButtons(this.followedMapButtons, uri != null);
        } else if ("associatedTemplateLocation".equals(propertyName)) {
            this.associatedMapLocation = uri;
            this.enableButtons(this.associatedMapButtons, uri != null);
        }
    }

    private void enableButtons(JButton[] buttons, boolean enabled) {
        Stream.of(buttons).forEach(button -> button.setEnabled(enabled));
    }

    public void show() {
        this.dialog.setVisible(true);
    }
}

