/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoLifecycleException;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleComponentMonitor
implements ComponentMonitor {
    private final ComponentMonitor delegate;
    private final List<RuntimeException> lifecycleFailures = new ArrayList<RuntimeException>();

    public LifecycleComponentMonitor(ComponentMonitor delegate) {
        this.delegate = delegate;
    }

    public LifecycleComponentMonitor() {
        this(new NullComponentMonitor());
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] parameters, long duration) {
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, parameters, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        this.delegate.instantiationFailed(container, componentAdapter, constructor, cause);
    }

    @Override
    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args) {
        return this.delegate.invoking(container, componentAdapter, member, instance, args);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args, Object retVal) {
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args, retVal);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception cause) {
        this.delegate.invocationFailed(member, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.lifecycleFailures.add(cause);
        try {
            this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
        }
        catch (PicoLifecycleException e) {
            // empty catch block
        }
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public Injector newInjector(Injector injector) {
        return this.delegate.newInjector(injector);
    }

    @Override
    public Behavior newBehavior(Behavior behavior) {
        return this.delegate.newBehavior(behavior);
    }

    public void rethrowLifecycleFailuresException() {
        throw new LifecycleFailuresException(this.lifecycleFailures);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class LifecycleFailuresException
    extends PicoException {
        private final List<RuntimeException> lifecycleFailures;

        public LifecycleFailuresException(List<RuntimeException> lifecycleFailures) {
            this.lifecycleFailures = lifecycleFailures;
        }

        @Override
        public String getMessage() {
            StringBuffer message = new StringBuffer();
            for (RuntimeException lifecycleFailure : this.lifecycleFailures) {
                Exception failure = lifecycleFailure;
                message.append(failure.getMessage()).append(";  ");
            }
            return message.toString();
        }

        public Collection<RuntimeException> getFailures() {
            return this.lifecycleFailures;
        }
    }
}

