/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclientjava;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.SSLContextFactory;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.service.IRemoteFileSystemBrowser;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.DefaultNTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.ECFHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.IHttpClientModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclientjava.INTLMProxyHandler;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.filetransfer.httpclientjava";
    public static final String USE_SHARED_CLIENT = "org.eclipse.ecf.provider.filetransfer.httpclientjava.sharedClient";
    private static final String USE_SHARED_CLIENT_DEFAULT = "true";
    public static final String USE_COOKIE_STORE = "org.eclipse.ecf.provider.filetransfer.httpclientjava.cookieStore";
    private static final String USE_COOKIE_STORE_DEFAULT = "true";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker<LogService, LogService> logServiceTracker = null;
    private ServiceTracker<SSLContextFactory, SSLContextFactory> sslContextFactoryTracker;
    private ServiceTracker<INTLMProxyHandler, INTLMProxyHandler> ntlmProxyHandlerTracker;
    private ServiceTracker<IHttpClientFactory, IHttpClientFactory> httpClientFactoryTracker;
    private ServiceTracker<HttpClient, HttpClient> browseClientTracker;
    private ServiceTracker<HttpClient, HttpClient> retrieveClientTracker;
    private boolean useSharedClient;
    private boolean useCookieStore;

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.useSharedClient = Boolean.parseBoolean(System.getProperty(USE_SHARED_CLIENT, "true"));
        this.useCookieStore = Boolean.parseBoolean(System.getProperty(USE_COOKIE_STORE, "true"));
        this.applyDebugOptions(ctxt);
    }

    private void applyDebugOptions(BundleContext ctxt) {
        DebugOptions debugOptions;
        ServiceReference debugRef = ctxt.getServiceReference(DebugOptions.class);
        DebugOptions debugOptions2 = debugOptions = debugRef == null ? null : (DebugOptions)ctxt.getService(debugRef);
        if (debugOptions == null) {
            return;
        }
        try {
            if (!debugOptions.isDebugEnabled()) {
                return;
            }
            Map options = debugOptions.getOptions();
            String ourDebugPrefix = "org.eclipse.ecf.provider.filetransfer.httpclientjava/";
            String ecfDebugPrefix = "org.eclipse.ecf.provider.filetransfer.httpclient4/";
            for (Map.Entry entry : options.entrySet()) {
                String ecfOption;
                String ecfValue;
                if (entry.getKey() == null || !((String)entry.getKey()).startsWith(ourDebugPrefix) || (ecfValue = (String)options.get(ecfOption = ecfDebugPrefix + ((String)entry.getKey()).substring(ourDebugPrefix.length()))) != null) continue;
                debugOptions.setOption(ecfOption, (String)entry.getValue());
            }
        }
        finally {
            ctxt.ungetService(debugRef);
        }
    }

    public synchronized void stop(BundleContext ctxt) throws Exception {
        if (this.sslContextFactoryTracker != null) {
            this.sslContextFactoryTracker.close();
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.ntlmProxyHandlerTracker != null) {
            this.ntlmProxyHandlerTracker.close();
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    private synchronized LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class, null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public boolean isUseSharedClient() {
        return this.useSharedClient;
    }

    public boolean isUseCookieStore() {
        return this.useCookieStore;
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            Logger logger = logService.getLogger(null);
            int code = status.getSeverity();
            String message = LogHelper.getLogMessage((IStatus)status);
            Throwable e = status.getException();
            switch (code) {
                case 4: {
                    if (!logger.isErrorEnabled()) break;
                    logger.error(message, (Object)e);
                    break;
                }
                case 2: {
                    if (!logger.isWarnEnabled()) break;
                    logger.warn(message, (Object)e);
                    break;
                }
                default: {
                    if (!logger.isInfoEnabled()) break;
                    logger.warn(message, (Object)e);
                }
            }
        }
    }

    public synchronized SSLContextFactory getSSLContextFactory() {
        if (this.sslContextFactoryTracker == null) {
            this.sslContextFactoryTracker = new ServiceTracker(this.context, SSLContextFactory.class, null);
            this.sslContextFactoryTracker.open();
        }
        SSLContextFactory service = (SSLContextFactory)this.sslContextFactoryTracker.getService();
        return service;
    }

    public synchronized INTLMProxyHandler getNTLMProxyHandler() {
        INTLMProxyHandler service;
        if (this.ntlmProxyHandlerTracker == null) {
            this.ntlmProxyHandlerTracker = new ServiceTracker(this.context, INTLMProxyHandler.class, null);
            this.ntlmProxyHandlerTracker.open();
        }
        if ((service = (INTLMProxyHandler)this.ntlmProxyHandlerTracker.getService()) == null) {
            service = new DefaultNTLMProxyHandler();
        }
        return service;
    }

    public synchronized IHttpClientFactory getHttpClientFactory() {
        IHttpClientFactory service;
        if (this.httpClientFactoryTracker == null) {
            this.httpClientFactoryTracker = new ServiceTracker(this.context, IHttpClientFactory.class, null);
            this.httpClientFactoryTracker.open();
        }
        if ((service = (IHttpClientFactory)this.httpClientFactoryTracker.getService()) == null) {
            service = new ECFHttpClientFactory();
            Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
            ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
            this.context.registerService(IHttpClientFactory.class, (Object)service, serviceProperties);
        }
        return service;
    }

    public synchronized HttpClient getBrowseHttpClient() {
        HttpClient service;
        if (this.isUseSharedClient()) {
            if (this.browseClientTracker == null) {
                this.browseClientTracker = new ServiceTracker(this.context, HttpClient.class, (ServiceTrackerCustomizer)new ScopedHttpClientCustomizer(this.context, IRemoteFileSystemBrowser.class.getName()));
                this.browseClientTracker.open();
            }
            if ((service = (HttpClient)this.browseClientTracker.getService()) == null) {
                service = this.registerHttpClient();
            }
        } else {
            service = this.buildHttpClient();
        }
        return service;
    }

    public synchronized HttpClient getRetrieveHttpClient() {
        HttpClient service;
        if (this.isUseSharedClient()) {
            if (this.retrieveClientTracker == null) {
                this.retrieveClientTracker = new ServiceTracker(this.context, HttpClient.class, (ServiceTrackerCustomizer)new ScopedHttpClientCustomizer(this.context, IRetrieveFileTransfer.class.getName()));
                this.retrieveClientTracker.open();
            }
            if ((service = (HttpClient)this.retrieveClientTracker.getService()) == null) {
                service = this.registerHttpClient();
            }
        } else {
            service = this.buildHttpClient();
        }
        return service;
    }

    private HttpClient registerHttpClient() {
        HttpClient client = this.buildHttpClient();
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)serviceProperties).put("http.client.scope", "org.eclipse.ecf.filetransfer.service.*");
        this.context.registerService(new String[]{HttpClient.class.getName()}, (Object)client, serviceProperties);
        return client;
    }

    private HttpClient buildHttpClient() {
        HttpClient.Builder builder = this.getHttpClientFactory().newClient();
        if (this.isUseCookieStore()) {
            CookieHandler cookieHandler = CookieHandler.getDefault();
            if (cookieHandler == null) {
                cookieHandler = new CookieManager();
            }
            builder.cookieHandler(cookieHandler);
        }
        return builder.build();
    }

    public static void logNoProxyWarning(Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, PLUGIN_ID, 4, "Warning: Platform proxy API not available", e));
        }
    }

    protected <T> T runModifiers(T value, ECFHttpClientFactory.ModifierRunner<T> modifierRunner) {
        T modifiedValue = value;
        List<ServiceReference<IHttpClientModifier>> orderedServices = this.getModifierReferences();
        for (ServiceReference<IHttpClientModifier> serviceReference : orderedServices) {
            IHttpClientModifier modifier = (IHttpClientModifier)this.context.getService(serviceReference);
            try {
                T newValue;
                if (modifier == null || (newValue = modifierRunner.run(modifier, modifiedValue)) == null) continue;
                modifiedValue = newValue;
            }
            finally {
                this.context.ungetService(serviceReference);
            }
        }
        return modifiedValue;
    }

    private List<ServiceReference<IHttpClientModifier>> getModifierReferences() {
        Collection serviceReferences;
        try {
            serviceReferences = this.context.getServiceReferences(IHttpClientModifier.class, null);
        }
        catch (InvalidSyntaxException e) {
            throw new ECFRuntimeException((Throwable)e);
        }
        ArrayList<ServiceReference<IHttpClientModifier>> orderedServices = new ArrayList<ServiceReference<IHttpClientModifier>>(serviceReferences);
        if (orderedServices.size() < 2) {
            return orderedServices;
        }
        Collections.sort(orderedServices, new Comparator<ServiceReference<?>>(){

            @Override
            public int compare(ServiceReference<?> o1, ServiceReference<?> o2) {
                if (o1 == o2) {
                    return 0;
                }
                int ranking1 = this.getServiceRanking(o1);
                int ranking2 = this.getServiceRanking(o2);
                return ranking1 - ranking2;
            }

            private int getServiceRanking(ServiceReference<?> reference) {
                Object rankingValue = reference.getProperty("service.ranking");
                if (rankingValue instanceof Integer) {
                    return (Integer)rankingValue;
                }
                if (rankingValue instanceof String) {
                    try {
                        return Integer.parseInt((String)rankingValue);
                    }
                    catch (NumberFormatException e) {
                        Trace.catching((String)Activator.PLUGIN_ID, (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", Activator.class, (String)"getServiceRanking", (Throwable)e);
                    }
                }
                return 0;
            }
        });
        return orderedServices;
    }

    private static final class ScopedHttpClientCustomizer
    implements ServiceTrackerCustomizer<HttpClient, HttpClient> {
        private final String neededScope;
        private final BundleContext context;

        public ScopedHttpClientCustomizer(BundleContext context, String neededScope) {
            this.context = context;
            this.neededScope = neededScope;
        }

        public HttpClient addingService(ServiceReference<HttpClient> reference) {
            if (!this.hasScope(reference, this.neededScope)) {
                return null;
            }
            return (HttpClient)this.context.getService(reference);
        }

        private boolean hasScope(ServiceReference<HttpClient> reference, String neededScope) {
            String[] scopes;
            Object scopeProperty = reference.getProperty("http.client.scope");
            if (scopeProperty == null || !(scopeProperty instanceof String)) {
                return false;
            }
            String[] stringArray = scopes = ((String)scopeProperty).split("\\s*,\\s*");
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                if (neededScope.equals(scope) || scope.endsWith("*") && neededScope.startsWith(scope.substring(0, scope.length() - 1))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void modifiedService(ServiceReference<HttpClient> reference, HttpClient service) {
            if (!this.hasScope(reference, this.neededScope)) {
                this.context.ungetService(reference);
            }
        }

        public void removedService(ServiceReference<HttpClient> reference, HttpClient service) {
            this.context.ungetService(reference);
        }
    }
}

