/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.hints.standard;

import java.util.Date;
import java.util.EnumSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.ValueHintText;

public class TimeZoneCellHintProvider
implements DBDCellHintProvider {
    private static final boolean SHOW_TZ_ALWAYS = true;

    @Override
    @Nullable
    public DBDValueHint[] getCellHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @Nullable Object value, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        if (attribute.getDataKind() == DBPDataKind.DATETIME) {
            String timezone = null;
            if (value instanceof Date) {
                Date ts = (Date)value;
                int timezoneOffset = ts.getTimezoneOffset() * -60000;
                timezone = TimeZoneCellHintProvider.toCustomID(timezoneOffset);
            }
            if (timezone != null) {
                return new DBDValueHint[]{new ValueHintText(timezone, "Timezone", null)};
            }
        }
        return null;
    }

    public static String toCustomID(int gmtOffset) {
        char sign;
        int offset = gmtOffset / 60000;
        if (offset >= 0) {
            sign = '+';
        } else {
            sign = '-';
            offset = -offset;
        }
        int hh = offset / 60;
        int mm = offset % 60;
        char[] buf = new char[]{'G', 'M', 'T', sign, '0', '0', ':', '0', '0'};
        if (hh >= 10) {
            buf[4] = (char)(buf[4] + (char)(hh / 10));
        }
        buf[5] = (char)(buf[5] + (char)(hh % 10));
        if (mm != 0) {
            buf[7] = (char)(buf[7] + (char)(mm / 10));
            buf[8] = (char)(buf[8] + (char)(mm % 10));
        }
        return new String(buf);
    }
}

