/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.parser.standard;

import com.rtfparserkit.parser.IRtfListener;
import com.rtfparserkit.parser.IRtfParser;
import com.rtfparserkit.parser.IRtfSource;
import com.rtfparserkit.parser.raw.RawRtfParser;
import com.rtfparserkit.parser.standard.BinaryBytesEvent;
import com.rtfparserkit.parser.standard.CommandEvent;
import com.rtfparserkit.parser.standard.DefaultEventHandler;
import com.rtfparserkit.parser.standard.DocumentEndEvent;
import com.rtfparserkit.parser.standard.DocumentStartEvent;
import com.rtfparserkit.parser.standard.Encoding;
import com.rtfparserkit.parser.standard.FontCharset;
import com.rtfparserkit.parser.standard.GroupEndEvent;
import com.rtfparserkit.parser.standard.GroupStartEvent;
import com.rtfparserkit.parser.standard.IParserEvent;
import com.rtfparserkit.parser.standard.IParserEventHandler;
import com.rtfparserkit.parser.standard.ParserEventType;
import com.rtfparserkit.parser.standard.ParserState;
import com.rtfparserkit.parser.standard.StringEvent;
import com.rtfparserkit.parser.standard.UprHandler;
import com.rtfparserkit.rtf.Command;
import com.rtfparserkit.rtf.CommandType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class StandardRtfParser
implements IRtfParser,
IRtfListener {
    private IParserEventHandler handler;
    private final Deque<IParserEventHandler> handlerStack = new ArrayDeque<IParserEventHandler>();
    private ParserState state = new ParserState();
    private final Deque<ParserState> stack = new ArrayDeque<ParserState>();
    private int skipBytes;
    private Map<Integer, String> m_fontEncodings = new HashMap<Integer, String>();
    private static final IParserEvent DOCUMENT_START = new DocumentStartEvent();
    private static final IParserEvent DOCUMENT_END = new DocumentEndEvent();
    private static final IParserEvent GROUP_START = new GroupStartEvent();
    private static final IParserEvent GROUP_END = new GroupEndEvent();

    @Override
    public void parse(IRtfSource source, IRtfListener listener) throws IOException {
        this.handler = new DefaultEventHandler(listener);
        RawRtfParser reader = new RawRtfParser();
        reader.parse(source, this);
    }

    @Override
    public void processGroupStart() {
        this.handleEvent(GROUP_START);
        this.stack.push(this.state);
        this.state = new ParserState(this.state);
    }

    @Override
    public void processGroupEnd() {
        this.handleEvent(GROUP_END);
        this.state = this.stack.pop();
    }

    @Override
    public void processCharacterBytes(byte[] data) {
        try {
            if (data.length != 0) {
                if (this.skipBytes < data.length) {
                    this.handleEvent(new StringEvent(new String(data, this.skipBytes, data.length - this.skipBytes, this.currentEncoding())));
                }
                this.skipBytes = 0;
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String currentEncoding() {
        if (!this.state.currentFontExplicitlySet) {
            this.state.currentFontExplicitlySet = true;
            this.state.currentFontEncoding = this.m_fontEncodings.get(0);
        }
        return this.state.currentFontEncoding == null ? this.state.currentEncoding : this.state.currentFontEncoding;
    }

    @Override
    public void processDocumentStart() {
        this.handleEvent(DOCUMENT_START);
    }

    @Override
    public void processDocumentEnd() {
        this.handleEvent(DOCUMENT_END);
    }

    @Override
    public void processBinaryBytes(byte[] data) {
        this.handleEvent(new BinaryBytesEvent(data));
    }

    @Override
    public void processString(String string) {
        this.handleEvent(new StringEvent(string));
    }

    @Override
    public void processCommand(Command command, int parameter, boolean hasParameter, boolean optional) {
        if (command.getCommandType() == CommandType.Encoding) {
            this.processEncoding(command, hasParameter, parameter);
        } else {
            boolean optionalFlag = false;
            IParserEvent lastEvent = this.handler.getLastEvent();
            if (lastEvent.getType() == ParserEventType.COMMAND_EVENT && ((CommandEvent)lastEvent).getCommand() == Command.optionalcommand) {
                this.handler.removeLastEvent();
                optionalFlag = true;
            }
            switch (command) {
                case u: {
                    this.processUnicode(parameter);
                    break;
                }
                case uc: {
                    this.processUnicodeAlternateSkipCount(parameter);
                    break;
                }
                case upr: {
                    this.processUpr(new CommandEvent(command, parameter, hasParameter, optionalFlag));
                    break;
                }
                case emdash: {
                    this.processCharacter('\u2014');
                    break;
                }
                case endash: {
                    this.processCharacter('\u2013');
                    break;
                }
                case emspace: {
                    this.processCharacter('\u2003');
                    break;
                }
                case enspace: {
                    this.processCharacter('\u2002');
                    break;
                }
                case qmspace: {
                    this.processCharacter('\u2005');
                    break;
                }
                case bullet: {
                    this.processCharacter('\u2022');
                    break;
                }
                case lquote: {
                    this.processCharacter('\u2018');
                    break;
                }
                case rquote: {
                    this.processCharacter('\u2019');
                    break;
                }
                case ldblquote: {
                    this.processCharacter('\u201c');
                    break;
                }
                case rdblquote: {
                    this.processCharacter('\u201d');
                    break;
                }
                case backslash: {
                    this.processCharacter('\\');
                    break;
                }
                case opencurly: {
                    this.processCharacter('{');
                    break;
                }
                case closecurly: {
                    this.processCharacter('}');
                    break;
                }
                case f: {
                    this.processFont(parameter);
                    this.handleCommand(command, parameter, hasParameter, optionalFlag);
                    break;
                }
                case fcharset: {
                    this.processFontCharset(parameter);
                    this.handleCommand(command, parameter, hasParameter, optionalFlag);
                    break;
                }
                case cpg: {
                    this.processFontCodepage(parameter);
                    this.handleCommand(command, parameter, hasParameter, optionalFlag);
                    break;
                }
                default: {
                    this.handleCommand(command, parameter, hasParameter, optionalFlag);
                }
            }
        }
    }

    private void processFont(int parameter) {
        this.state.currentFontExplicitlySet = true;
        this.state.currentFont = parameter;
        this.state.currentFontEncoding = this.m_fontEncodings.get(parameter);
    }

    private void processFontCharset(int parameter) {
        this.setFontEncoding(FontCharset.getCharset(parameter));
    }

    private void processFontCodepage(int parameter) {
        this.setFontEncoding(Integer.toString(parameter));
    }

    private void setFontEncoding(String charset) {
        String encoding;
        if (charset != null && (encoding = Encoding.LOCALEID_MAPPING.get(charset)) != null) {
            this.m_fontEncodings.put(this.state.currentFont, encoding);
        }
    }

    private void processEncoding(Command command, boolean hasParameter, int parameter) {
        String encoding = null;
        switch (command) {
            case ansi: {
                encoding = "Cp1252";
                break;
            }
            case pc: {
                encoding = "Cp437";
                break;
            }
            case pca: {
                encoding = "Cp850";
                break;
            }
            case mac: {
                encoding = "MacRoman";
                break;
            }
            case ansicpg: {
                encoding = hasParameter ? Encoding.LOCALEID_MAPPING.get(Integer.toString(this.unsignedValue(parameter))) : null;
                break;
            }
            default: {
                encoding = null;
            }
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Unsupported encoding command " + command.getCommandName() + (hasParameter ? Integer.valueOf(parameter) : ""));
        }
        this.state.currentEncoding = encoding;
    }

    private void processUnicode(int parameter) {
        this.processCharacter((char)this.unsignedValue(parameter));
        this.skipBytes = this.state.unicodeAlternateSkipCount;
    }

    private void processUnicodeAlternateSkipCount(int parameter) {
        this.state.unicodeAlternateSkipCount = parameter;
    }

    private void processUpr(IParserEvent command) {
        UprHandler uprHandler = new UprHandler(this.handler);
        uprHandler.handleEvent(command);
        this.handlerStack.push(this.handler);
        this.handler = uprHandler;
    }

    private void processCharacter(char c) {
        this.handleEvent(new StringEvent(Character.toString(c)));
    }

    private void handleCommand(Command command, int parameter, boolean hasParameter, boolean optional) {
        this.handleEvent(new CommandEvent(command, parameter, hasParameter, optional));
    }

    private void handleEvent(IParserEvent event) {
        this.handler.handleEvent(event);
        if (this.handler.isComplete()) {
            this.handler = this.handlerStack.pop();
        }
    }

    private int unsignedValue(int parameter) {
        if (parameter < 0) {
            parameter += 65536;
        }
        return parameter;
    }
}

