/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;

public class NRTCachingDirectory
extends FilterDirectory
implements Accountable {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicLong cacheSize = new AtomicLong();
    private final ByteBuffersDirectory cacheDirectory = new ByteBuffersDirectory(new SingleInstanceLockFactory(), ByteBuffersDataOutput::new, (fileName, content) -> {
        if (!this.isCachedFile((String)fileName)) {
            return null;
        }
        this.cacheSize.addAndGet(content.size());
        return ByteBuffersDirectory.OUTPUT_AS_MANY_BUFFERS_LUCENE.apply((String)fileName, (ByteBuffersDataOutput)content);
    });
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;

    public NRTCachingDirectory(Directory delegate, double maxMergeSizeMB, double maxCachedMB) {
        super(delegate);
        this.maxMergeSizeBytes = (long)(maxMergeSizeMB * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(maxCachedMB * 1024.0 * 1024.0);
    }

    @Override
    public String toString() {
        return "NRTCachingDirectory(" + String.valueOf(this.in) + "; maxCacheMB=" + (double)this.maxCachedBytes / 1024.0 / 1024.0 + " maxMergeSizeMB=" + (double)this.maxMergeSizeBytes / 1024.0 / 1024.0 + ")";
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.cacheDirectory.listAll()) {
            files.add(f);
        }
        for (String f : this.in.listAll()) {
            files.add(f);
        }
        Object[] result = files.toArray(new String[files.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public synchronized void deleteFile(String name) throws IOException {
        if (this.cacheDirectory.fileExists(name)) {
            long size = this.cacheDirectory.fileLength(name);
            this.cacheDirectory.deleteFile(name);
            long newSize = this.cacheSize.addAndGet(-size);
            assert (newSize >= 0L);
        } else {
            this.in.deleteFile(name);
        }
    }

    @Override
    public synchronized long fileLength(String name) throws IOException {
        if (this.cacheDirectory.fileExists(name)) {
            return this.cacheDirectory.fileLength(name);
        }
        return this.in.fileLength(name);
    }

    public String[] listCachedFiles() {
        try {
            return this.cacheDirectory.listAll();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        if (this.doCacheWrite(name, context)) {
            return this.cacheDirectory.createOutput(name, context);
        }
        return this.in.createOutput(name, context);
    }

    @Override
    public void sync(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            this.unCache(fileName);
        }
        this.in.sync(fileNames);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.unCache(source);
        if (this.cacheDirectory.fileExists(dest)) {
            throw new IllegalArgumentException("target file " + dest + " already exists");
        }
        this.in.rename(source, dest);
    }

    @Override
    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        if (this.cacheDirectory.fileExists(name)) {
            return this.cacheDirectory.openInput(name, context);
        }
        return this.in.openInput(name, context);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> {
            if (!this.closed.getAndSet(true)) {
                for (String fileName : this.cacheDirectory.listAll()) {
                    this.unCache(fileName);
                }
            }
        }, this.cacheDirectory, this.in);
    }

    protected boolean doCacheWrite(String name, IOContext context) {
        long bytes = 0L;
        if (context.mergeInfo != null) {
            bytes = context.mergeInfo.estimatedMergeBytes;
        } else if (context.flushInfo != null) {
            bytes = context.flushInfo.estimatedSegmentSize;
        } else {
            return false;
        }
        return bytes <= this.maxMergeSizeBytes && bytes + this.cacheSize.get() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        IndexOutput out;
        block8: {
            Directory first;
            HashSet<String> toDelete;
            block7: {
                Directory second;
                toDelete = new HashSet<String>();
                boolean success = false;
                if (this.doCacheWrite(prefix, context)) {
                    first = this.cacheDirectory;
                    second = this.in;
                } else {
                    first = this.in;
                    second = this.cacheDirectory;
                }
                out = null;
                try {
                    String name;
                    while (true) {
                        out = first.createTempOutput(prefix, suffix, context);
                        name = out.getName();
                        toDelete.add(name);
                        if (!NRTCachingDirectory.slowFileExists(second, name)) break;
                        out.close();
                    }
                    toDelete.remove(name);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.deleteFiles(first, toDelete);
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                        IOUtils.deleteFilesIgnoringExceptions(first, toDelete);
                    }
                    throw throwable;
                }
                IOUtils.deleteFiles(first, toDelete);
                break block8;
            }
            IOUtils.closeWhileHandlingException(out);
            IOUtils.deleteFilesIgnoringExceptions(first, toDelete);
        }
        return out;
    }

    static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.fileLength(fileName);
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    private synchronized boolean isCachedFile(String fileName) {
        return this.cacheDirectory.fileExists(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String fileName) throws IOException {
        NRTCachingDirectory nRTCachingDirectory = this;
        synchronized (nRTCachingDirectory) {
            if (!this.cacheDirectory.fileExists(fileName)) {
                return;
            }
            assert (!NRTCachingDirectory.slowFileExists(this.in, fileName)) : "fileName=" + fileName + " exists both in cache and in delegate";
            this.in.copyFrom(this.cacheDirectory, fileName, fileName, IOContext.DEFAULT);
            this.cacheSize.addAndGet(-this.cacheDirectory.fileLength(fileName));
            this.cacheDirectory.deleteFile(fileName);
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.cacheSize.get();
    }
}

