/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jetty;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jetty.SolrJettyMetric;

public class SolrJettyReqRespMetric
extends SolrJettyMetric {
    public static final String JETTY_RESPONSES_TOTAL = "solr_metrics_jetty_response";
    public static final String JETTY_REQUESTS_TOTAL = "solr_metrics_jetty_requests";

    public SolrJettyReqRespMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        String label = parsedMetric[parsedMetric.length - 1].split("-")[0];
        if (this.metricName.endsWith("xx-responses")) {
            this.labels.put("status", label);
        } else {
            this.labels.put("method", label);
        }
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.metricName.endsWith("xx-responses")) {
            formatter.exportMeter(JETTY_RESPONSES_TOTAL, (Meter)this.dropwizardMetric, this.getLabels());
        } else if (this.metricName.endsWith("-requests")) {
            if (this.dropwizardMetric instanceof Counter) {
                formatter.exportCounter(JETTY_REQUESTS_TOTAL, (Counter)this.dropwizardMetric, this.getLabels());
            } else if (this.dropwizardMetric instanceof Timer) {
                formatter.exportTimerCount(JETTY_REQUESTS_TOTAL, (Timer)this.dropwizardMetric, this.getLabels());
            }
        }
    }
}

