/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache.internal;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbt.boot.internal.shaded.coursier.cache.ArtifactError;
import xsbt.boot.internal.shaded.coursier.cache.ArtifactError$NotFound$;
import xsbt.boot.internal.shaded.coursier.cache.CacheLogger;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$FetchMissing$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$ForceDownload$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalOnly$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalOnlyIfValid$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalUpdate$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$Update$;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy$UpdateChanging$;
import xsbt.boot.internal.shaded.coursier.cache.FileCache$;
import xsbt.boot.internal.shaded.coursier.cache.internal.DownloadResult;
import xsbt.boot.internal.shaded.coursier.cache.internal.DownloadResult$;
import xsbt.boot.internal.shaded.coursier.cache.internal.Downloader$Blocking$;
import xsbt.boot.internal.shaded.coursier.cache.internal.Retry;
import xsbt.boot.internal.shaded.coursier.core.Authentication;
import xsbt.boot.internal.shaded.coursier.paths.Util;
import xsbt.boot.internal.shaded.coursier.util.Artifact;
import xsbt.boot.internal.shaded.coursier.util.EitherT;
import xsbt.boot.internal.shaded.coursier.util.Monad$ops$;
import xsbt.boot.internal.shaded.coursier.util.Sync;

public final class Downloader<F>
implements Serializable,
Product {
    private Option<File> referenceFileOpt;
    private volatile Downloader<F> Blocking$module;
    private final Artifact artifact;
    private final CachePolicy cachePolicy;
    private final File location;
    private final Seq<String> actualChecksums;
    private final F allCredentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int bufferSize;
    private final Seq<ClassLoader> classLoaders;
    private final Clock clock;
    private final int retryCount;
    private final FiniteDuration retryBackoffInitialDelay;
    private final double retryBackoffMultiplier;
    private final Sync<F> S;
    private final Retry coursier$cache$internal$Downloader$$retry;
    private final boolean cacheErrors;
    private final CachePolicy.Mixed actualCachePolicy;
    private volatile boolean bitmap$0;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final Downloader<F> coursier$cache$internal$Downloader$$Blocking() {
        if (this.Blocking$module == null) {
            this.Blocking$lzycompute$1();
        }
        return this.Blocking$module;
    }

    public final Artifact artifact() {
        return this.artifact;
    }

    public final CachePolicy cachePolicy() {
        return this.cachePolicy;
    }

    public final File location() {
        return this.location;
    }

    public final Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    public final F allCredentials() {
        return this.allCredentials;
    }

    public final CacheLogger logger() {
        return this.logger;
    }

    public final ExecutorService pool() {
        return this.pool;
    }

    public final Option<Duration> ttl() {
        return this.ttl;
    }

    public final boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public final boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public final boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public final Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public final int sslRetry() {
        return this.sslRetry;
    }

    public final Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public final Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    public final Seq<ClassLoader> classLoaders() {
        return this.classLoaders;
    }

    public final Clock clock() {
        return this.clock;
    }

    public final int retryCount() {
        return this.retryCount;
    }

    public final FiniteDuration retryBackoffInitialDelay() {
        return this.retryBackoffInitialDelay;
    }

    public final double retryBackoffMultiplier() {
        return this.retryBackoffMultiplier;
    }

    public final Sync<F> S() {
        return this.S;
    }

    public final Retry coursier$cache$internal$Downloader$$retry() {
        return this.coursier$cache$internal$Downloader$$retry;
    }

    /*
     * WARNING - void declaration
     */
    private <T> F blockingIO(Function0<T> f) {
        void var1_1;
        return this.S().schedule(this.pool(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private <T> EitherT<F, ArtifactError, T> blockingIOE(Function0<Either<ArtifactError, T>> f) {
        void var1_1;
        return new EitherT(this.S().schedule(this.pool(), var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private File localFile(String url, Option<String> user) {
        void var2_2;
        void var1_1;
        return FileCache$.MODULE$.localFile0((String)var1_1, this.location(), (Option<String>)var2_2, this.localArtifactsShouldBeCached());
    }

    private Option<File> referenceFileOpt$lzycompute() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (!this.bitmap$0) {
                this.referenceFileOpt = this.artifact().extra().get("metadata").map((Function1<Artifact, File> & Serializable)a -> {
                    void var1_1;
                    return this.localFile(a.url(), var1_1.authentication().map((Function1<Authentication, String> & Serializable)x$1 -> x$1.user()));
                });
                this.bitmap$0 = true;
            }
        }
        return this.referenceFileOpt;
    }

    private Option<File> referenceFileOpt() {
        if (!this.bitmap$0) {
            return this.referenceFileOpt$lzycompute();
        }
        return this.referenceFileOpt;
    }

    private boolean cacheErrors() {
        return this.cacheErrors;
    }

    private boolean cacheErrors0() {
        return this.cacheErrors() || this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.exists()));
    }

    /*
     * WARNING - void declaration
     */
    private F urlLastModified(String url, Option<Object> currentLastModifiedOpt, CacheLogger logger) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap(arg_0 -> Downloader.$anonfun$urlLastModified$3(this, (String)var1_1, (Option)var2_2, (CacheLogger)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final File coursier$cache$internal$Downloader$$ttlFile(File file) {
        void var1_1;
        return new File(file.getParent(), new StringBuilder(9).append(".").append(var1_1.getName()).append(".checked").toString());
    }

    /*
     * WARNING - void declaration
     */
    private F checkNeeded(File file) {
        boolean bl = false;
        Some some = null;
        Option<Duration> option = this.ttl();
        if (None$.MODULE$.equals(option)) {
            return this.S().point(BoxesRunTime.boxToBoolean(true));
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Duration duration = (Duration)some.value();
            if (!duration.isFinite()) {
                return this.S().point(BoxesRunTime.boxToBoolean(false));
            }
        }
        if (bl) {
            void var2_3;
            void var1_1;
            Duration ttl = (Duration)some.value();
            Downloader downloader = this;
            return downloader.blockingIO(() -> Downloader.$anonfun$checkNeeded$1(downloader, (File)var1_1, (Duration)var2_3));
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkNeededBlocking(File file) {
        boolean bl = false;
        Some some = null;
        Option<Duration> option = this.ttl();
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Duration duration = (Duration)some.value();
            if (!duration.isFinite()) {
                return false;
            }
        }
        if (bl) {
            void var2_3;
            void var1_1;
            Duration ttl = (Duration)some.value();
            return BoxesRunTime.unboxToBoolean(this.coursier$cache$internal$Downloader$$Blocking().lastCheck((File)var1_1).fold(() -> true, arg_0 -> Downloader.$anonfun$checkNeededBlocking$2(this, (Duration)var2_3, arg_0)));
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, ArtifactError, Object> shouldDownload(File file, String url, boolean checkRemote) {
        void var2_2;
        void var3_3;
        void var1_1;
        Downloader downloader = this;
        return downloader.blockingIOE((Function0<Either> & Serializable)() -> {
            void var2_2;
            void var1_1;
            return downloader.checkErrFile$1((File)var1_1, (String)var2_2);
        }).flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$17(this, (File)var1_1, (boolean)var3_3, (String)var2_2, arg_0), this.S());
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldDownloadSecondCheckBlocking(File file) {
        void var1_1;
        return !file.exists() || this.checkNeededBlocking((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private F remote(File file, String url, boolean keepHeaderChecksums, Function0<Object> proceed) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.S()).flatMap(arg_0 -> Downloader.$anonfun$remote$5(this, (File)var1_1, (String)var2_2, (boolean)var3_3, proceed, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private File errFile(File file) {
        void var1_1;
        return new File(file.getParentFile(), new StringBuilder(7).append(".").append(var1_1.getName()).append(".error").toString());
    }

    /*
     * WARNING - void declaration
     */
    private F remoteKeepErrors(File file, String url, boolean keepHeaderChecksums, Function0<Object> proceed) {
        void var3_3;
        void var2_2;
        void var1_1;
        File errFile0 = this.errFile(file);
        return Monad$ops$.MODULE$.toAllMonadOps(this.remote((File)var1_1, (String)var2_2, (boolean)var3_3, proceed), this.S()).flatMap((Function1<Either, Object> & Serializable)e -> {
            void var1_1;
            void var2_2;
            Downloader downloader = this;
            return downloader.blockingIO(() -> Downloader.$anonfun$remoteKeepErrors$2(downloader, (Either)var2_2, (File)var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkFileExistsBlocking(File file, String url) {
        if (file.exists()) {
            void var2_2;
            this.logger().foundLocally((String)var2_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private F checkFileExists(File file, String url, boolean log) {
        void var2_2;
        void var1_1;
        Downloader downloader = this;
        return downloader.blockingIO(() -> Downloader.$anonfun$checkFileExists$1(downloader, (File)var1_1, (String)var2_2));
    }

    private boolean checkFileExists$default$3() {
        return true;
    }

    private CachePolicy.Mixed actualCachePolicy() {
        return this.actualCachePolicy;
    }

    /*
     * WARNING - void declaration
     */
    private F downloadUrl(String url, boolean keepHeaderChecksums) {
        void var3_4;
        void var1_1;
        void var2_3;
        this.logger().checkingArtifact(url, this.artifact());
        File file = this.localFile(url, this.artifact().authentication().map((Function1<Authentication, String> & Serializable)x$17 -> x$17.user()));
        Object run0 = this.artifact().changing() && !this.cachePolicy().acceptsChangingArtifacts() ? this.S().point(new Left(new ArtifactError.ForbiddenChangingArtifact(url))) : this.run$1(url, file, keepHeaderChecksums);
        return Monad$ops$.MODULE$.toAllMonadOps(var2_3, this.S()).map(arg_0 -> Downloader.$anonfun$downloadUrl$13((String)var1_1, (File)var3_4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final F download() {
        void var1_1;
        Downloader downloader = this;
        F mainTask = downloader.downloadUrl(downloader.artifact().url(), true);
        return Monad$ops$.MODULE$.toAllMonadOps(var1_1, this.S()).flatMap((Function1<DownloadResult, Object> & Serializable)r -> {
            void var1_1;
            Downloader downloader;
            void var2_2;
            Object f;
            Seq l2;
            if (r.errorOpt().isEmpty()) {
                l2 = (Seq)this.actualChecksums().map((Function1<String, Object> & Serializable)c -> {
                    void var1_1;
                    void var2_2;
                    Downloader downloader;
                    File candidate = FileCache$.MODULE$.auxiliaryFile(r.file(), (String)c);
                    return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> candidate.exists()), this.S()).map(arg_0 -> Downloader.$anonfun$download$5$adapted(downloader, (String)var2_2, (File)var1_1, arg_0));
                });
                f = Monad$ops$.MODULE$.toAllMonadOps(this.S().gather(l2), this.S()).flatMap((Function1<Seq, Object> & Serializable)l -> {
                    void var1_1;
                    return this.S().gather((Seq)var1_1.flatten(Predef$.MODULE$.$conforms()));
                });
            } else {
                l2 = (Seq)this.actualChecksums().flatMap((Function1<String, Seq> & Serializable)c -> {
                    void var1_1;
                    return this.checksumRes$1((String)var1_1);
                });
                f = this.S().gather(l2);
            }
            Object l0 = f;
            return Monad$ops$.MODULE$.toAllMonadOps(var2_2, downloader.S()).map(arg_0 -> Downloader.$anonfun$download$10((DownloadResult)var1_1, arg_0));
        });
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder b = new StringBuilder("Downloader(");
        b.append(String.valueOf(this.artifact()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicy()));
        b.append(", ");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.actualChecksums()));
        b.append(", ");
        b.append(String.valueOf(this.allCredentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.classLoaders()));
        b.append(", ");
        b.append(String.valueOf(this.clock()));
        b.append(", ");
        b.append(String.valueOf(this.retryCount()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffInitialDelay()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffMultiplier()));
        b.append(", ");
        b.append(String.valueOf(this.S()));
        b.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof Downloader;
    }

    public final boolean equals(Object obj) {
        block3: {
            block2: {
                Sync<F> sync;
                if (this == obj) break block2;
                if (!this.canEqual(obj)) break block3;
                Downloader other = (Downloader)obj;
                Artifact artifact = this.artifact();
                Object object = other.artifact();
                if (artifact != null ? !((Object)artifact).equals(object) : object != null) break block3;
                CachePolicy cachePolicy = this.cachePolicy();
                object = other.cachePolicy();
                if (cachePolicy != null ? !cachePolicy.equals(object) : object != null) break block3;
                File file = this.location();
                object = other.location();
                if (file != null ? !((Object)file).equals(object) : object != null) break block3;
                Seq<String> seq = this.actualChecksums();
                object = other.actualChecksums();
                if ((seq != null ? !seq.equals(object) : object != null) || !BoxesRunTime.equals(this.allCredentials(), other.allCredentials())) break block3;
                CacheLogger cacheLogger = this.logger();
                object = other.logger();
                if (cacheLogger != null ? !cacheLogger.equals(object) : object != null) break block3;
                ExecutorService executorService = this.pool();
                object = other.pool();
                if (executorService != null ? !executorService.equals(object) : object != null) break block3;
                Option<Duration> option = this.ttl();
                object = other.ttl();
                if (option != null ? !option.equals(object) : object != null) break block3;
                if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached() || this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections() || this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) break block3;
                Option<Object> option2 = this.maxRedirections();
                object = other.maxRedirections();
                if ((option2 != null ? !option2.equals(object) : object != null) || this.sslRetry() != other.sslRetry()) break block3;
                Option<SSLSocketFactory> option3 = this.sslSocketFactoryOpt();
                object = other.sslSocketFactoryOpt();
                if (option3 != null ? !option3.equals(object) : object != null) break block3;
                Option<HostnameVerifier> option4 = this.hostnameVerifierOpt();
                object = other.hostnameVerifierOpt();
                if ((option4 != null ? !option4.equals(object) : object != null) || this.bufferSize() != other.bufferSize()) break block3;
                Seq<ClassLoader> seq2 = this.classLoaders();
                object = other.classLoaders();
                if (seq2 != null ? !seq2.equals(object) : object != null) break block3;
                Clock clock = this.clock();
                object = other.clock();
                if ((clock != null ? !((Object)clock).equals(object) : object != null) || this.retryCount() != other.retryCount()) break block3;
                FiniteDuration finiteDuration = this.retryBackoffInitialDelay();
                object = other.retryBackoffInitialDelay();
                if ((finiteDuration != null ? !((Object)finiteDuration).equals(object) : object != null) || this.retryBackoffMultiplier() != other.retryBackoffMultiplier()) break block3;
                Sync<F> sync2 = this.S();
                sync = ((Downloader)((Object)sync)).S();
                if (sync2 != null ? !sync2.equals(sync) : sync != null) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("Downloader");
        code = code * 37 + Statics.anyHash(this.artifact());
        code = code * 37 + Statics.anyHash(this.cachePolicy());
        code = code * 37 + Statics.anyHash(this.location());
        code = code * 37 + Statics.anyHash(this.actualChecksums());
        code = code * 37 + Statics.anyHash(this.allCredentials());
        code = code * 37 + Statics.anyHash(this.logger());
        code = code * 37 + Statics.anyHash(this.pool());
        code = code * 37 + Statics.anyHash(this.ttl());
        code = code * 37 + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = code * 37 + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = code * 37 + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = code * 37 + Statics.anyHash(this.maxRedirections());
        code = code * 37 + this.sslRetry();
        code = code * 37 + Statics.anyHash(this.sslSocketFactoryOpt());
        code = code * 37 + Statics.anyHash(this.hostnameVerifierOpt());
        code = code * 37 + this.bufferSize();
        code = code * 37 + Statics.anyHash(this.classLoaders());
        code = code * 37 + Statics.anyHash(this.clock());
        code = code * 37 + this.retryCount();
        code = code * 37 + Statics.anyHash(this.retryBackoffInitialDelay());
        code = code * 37 + Statics.doubleHash(this.retryBackoffMultiplier());
        code = code * 37 + Statics.anyHash(this.S());
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "Downloader";
    }

    @Override
    public final int productArity() {
        return 22;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.artifact();
            }
            case 1: {
                return this.cachePolicy();
            }
            case 2: {
                return this.location();
            }
            case 3: {
                return this.actualChecksums();
            }
            case 4: {
                return this.allCredentials();
            }
            case 5: {
                return this.logger();
            }
            case 6: {
                return this.pool();
            }
            case 7: {
                return this.ttl();
            }
            case 8: {
                return BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
            }
            case 9: {
                return BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
            }
            case 10: {
                return BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
            }
            case 11: {
                return this.maxRedirections();
            }
            case 12: {
                return BoxesRunTime.boxToInteger(this.sslRetry());
            }
            case 13: {
                return this.sslSocketFactoryOpt();
            }
            case 14: {
                return this.hostnameVerifierOpt();
            }
            case 15: {
                return BoxesRunTime.boxToInteger(this.bufferSize());
            }
            case 16: {
                return this.classLoaders();
            }
            case 17: {
                return this.clock();
            }
            case 18: {
                return BoxesRunTime.boxToInteger(this.retryCount());
            }
            case 19: {
                return this.retryBackoffInitialDelay();
            }
            case 20: {
                return BoxesRunTime.boxToDouble(this.retryBackoffMultiplier());
            }
            case 21: {
                return this.S();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString((int)var1_1));
    }

    private final void Blocking$lzycompute$1() {
        Downloader downloader = this;
        synchronized (downloader) {
            if (this.Blocking$module == null) {
                this.Blocking$module = new Downloader$Blocking$(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$urlLastModified$4(Downloader $this, String url$4, Option currentLastModifiedOpt$1, CacheLogger logger$1, Seq allCredentials0$3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.coursier$cache$internal$Downloader$$Blocking().urlLastModified((String)var1_1, (Option<Object>)var2_2, (CacheLogger)var3_3, allCredentials0$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$urlLastModified$3(Downloader $this, String url$4, Option currentLastModifiedOpt$1, CacheLogger logger$1, Seq allCredentials0) {
        void var3_3;
        void var2_2;
        void var1_1;
        Downloader downloader = $this;
        return downloader.blockingIO(() -> Downloader.$anonfun$urlLastModified$4(downloader, (String)var1_1, (Option)var2_2, (CacheLogger)var3_3, allCredentials0));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$checkNeeded$3(Downloader $this, Duration ttl$1, long ts) {
        void var1_1;
        void var2_2;
        long l = $this.clock().millis();
        return l > var2_2 + var1_1.toMillis();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$checkNeeded$1(Downloader $this, File file$4, Duration ttl$1) {
        void var2_2;
        Downloader downloader;
        void var1_1;
        return BoxesRunTime.unboxToBoolean($this.coursier$cache$internal$Downloader$$Blocking().lastCheck((File)var1_1).fold(() -> true, arg_0 -> Downloader.$anonfun$checkNeeded$3(downloader, (Duration)var2_2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$checkNeededBlocking$2(Downloader $this, Duration ttl$2, long ts) {
        void var1_1;
        void var2_2;
        long l = $this.clock().millis();
        return l > var2_2 + var1_1.toMillis();
    }

    public static final /* synthetic */ boolean $anonfun$shouldDownload$2(Duration x$14) {
        return !x$14.isFinite();
    }

    /*
     * WARNING - void declaration
     */
    private final Either checkErrFile$1(File file$5, String url$5) {
        File errFile0 = this.errFile(file$5);
        if (this.referenceFileOpt().exists((Function1<File, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.exists())) && errFile0.exists()) {
            return new Left(new ArtifactError.NotFound(url$5, new Some<Object>(BoxesRunTime.boxToBoolean(true))));
        }
        if (this.cacheErrors() && errFile0.exists()) {
            void var1_1;
            long ts = var1_1.lastModified();
            long now = this.clock().millis();
            if (ts > 0L && (this.ttl().exists((Function1<Duration, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$2(x$14))) || now < ts + BoxesRunTime.unboxToLong(this.ttl().fold(() -> 0L, (Function1<Duration, Object> & Serializable)x$15 -> BoxesRunTime.boxToLong(x$15.toMillis()))))) {
                void var2_2;
                return new Left(new ArtifactError.NotFound((String)var2_2, ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
            }
            return new Right(BoxedUnit.UNIT);
        }
        return new Right(BoxedUnit.UNIT);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$shouldDownload$5(Downloader $this, File file$5) {
        void var1_1;
        return $this.coursier$cache$internal$Downloader$$Blocking().fileLastModified((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$shouldDownload$9(long fileLastMod$1, long urlLastMod) {
        void var2_1;
        return fileLastMod$1 < var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$shouldDownload$8(Option urlLastModOpt$1, long fileLastMod) {
        void var1_1;
        return urlLastModOpt$1.map(arg_0 -> Downloader.$anonfun$shouldDownload$9((long)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$shouldDownload$7(Option fileLastModOpt$1, Option urlLastModOpt) {
        void var1_1;
        Option<Object> option = fileLastModOpt$1.flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$8$adapted((Option)var1_1, arg_0));
        return BoxesRunTime.unboxToBoolean(option.getOrElse(() -> true));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$shouldDownload$6(Downloader $this, String url$5, Option fileLastModOpt) {
        Downloader downloader;
        void var2_2;
        void var1_1;
        return new EitherT($this.urlLastModified((String)var1_1, fileLastModOpt, $this.logger())).map(arg_0 -> Downloader.$anonfun$shouldDownload$7$adapted((Option)var2_2, arg_0), downloader.S());
    }

    /*
     * WARNING - void declaration
     */
    private final EitherT doCheckRemote$1(File file$5, String url$5) {
        void var2_2;
        void var1_1;
        Downloader downloader = this;
        return downloader.blockingIOE(() -> Downloader.$anonfun$shouldDownload$5(downloader, (File)var1_1)).flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$6(this, (String)var2_2, arg_0), this.S());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Right $anonfun$shouldDownload$15(Downloader $this, File file$5, String url$5) {
        void var2_2;
        void var1_1;
        $this.coursier$cache$internal$Downloader$$Blocking().doTouchCheckFile((File)var1_1, (String)var2_2, false);
        return new Right(BoxesRunTime.boxToBoolean(false));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$14(Downloader $this, File file$5, String url$5, Either x0$3) {
        Downloader downloader;
        Right right;
        boolean bl;
        Either either = x0$3;
        if (either instanceof Right && !(bl = BoxesRunTime.unboxToBoolean((right = (Right)either).value()))) {
            void var2_2;
            void var1_1;
            Downloader downloader2 = $this;
            return downloader2.blockingIO(() -> Downloader.$anonfun$shouldDownload$15(downloader2, (File)var1_1, (String)var2_2));
        }
        return downloader.S().point(either);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$13(Downloader $this, boolean checkRemote$1, File file$5, String url$5, boolean x0$2) {
        if (!x0$2) {
            return $this.S().point(new Right(BoxesRunTime.boxToBoolean(false)));
        }
        if (x0$2) {
            Downloader downloader;
            void var1_1;
            if (var1_1 != false) {
                void var3_3;
                void var2_2;
                return Monad$ops$.MODULE$.toAllMonadOps($this.doCheckRemote$1(file$5, url$5).run(), $this.S()).flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$14($this, (File)var2_2, (String)var3_3, arg_0));
            }
            return downloader.S().point(new Right(BoxesRunTime.boxToBoolean(true)));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(x0$2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$12(Downloader $this, File file$5, boolean checkRemote$1, String url$5, boolean x0$1) {
        if (!x0$1) {
            return $this.S().point(new Right(BoxesRunTime.boxToBoolean(true)));
        }
        if (x0$1) {
            void var3_3;
            void var1_1;
            void var2_2;
            Downloader downloader;
            return Monad$ops$.MODULE$.toAllMonadOps($this.checkNeeded(file$5), $this.S()).flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$13$adapted(downloader, (boolean)var2_2, (File)var1_1, (String)var3_3, arg_0));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(x0$1));
    }

    /*
     * WARNING - void declaration
     */
    private final Object checkShouldDownload$1(File file$5, boolean checkRemote$1, String url$5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Monad$ops$.MODULE$.toAllMonadOps(this.blockingIO(() -> file$5.exists()), this.S()).flatMap(arg_0 -> Downloader.$anonfun$shouldDownload$12$adapted(this, (File)var1_1, (boolean)var2_2, (String)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$shouldDownload$17(Downloader $this, File file$5, boolean checkRemote$1, String url$5, BoxedUnit x$16) {
        Downloader downloader;
        void var3_3;
        void var2_2;
        void var1_1;
        return new EitherT($this.checkShouldDownload$1((File)var1_1, (boolean)var2_2, (String)var3_3)).map((Function1<Object, Object> & Serializable)res -> BoxesRunTime.boxToBoolean(BoxesRunTime.unboxToBoolean(res)), downloader.S());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$remote$6(Downloader $this, File file$6, String url$6, boolean keepHeaderChecksums$2, Seq allCredentials0$4, Function0 proceed$2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.coursier$cache$internal$Downloader$$Blocking().remote((File)var1_1, (String)var2_2, (boolean)var3_3, allCredentials0$4, proceed$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$remote$5(Downloader $this, File file$6, String url$6, boolean keepHeaderChecksums$2, Function0 proceed$2, Seq allCredentials0) {
        void var3_3;
        void var2_2;
        void var1_1;
        Downloader downloader = $this;
        return downloader.blockingIO(() -> Downloader.$anonfun$remote$6(downloader, (File)var1_1, (String)var2_2, (boolean)var3_3, allCredentials0, proceed$2));
    }

    /*
     * WARNING - void declaration
     */
    private final Object createErrFileBlocking$1(File errFile0$1) {
        if (this.cacheErrors0()) {
            void var1_1;
            Path p = errFile0$1.toPath();
            Util.createDirectories(p.getParent());
            return Files.write((Path)var1_1, Array$.MODULE$.emptyByteArray(), new OpenOption[0]);
        }
        return BoxedUnit.UNIT;
    }

    private static final Object deleteErrFileBlocking$1(File errFile0$1) {
        if (errFile0$1.exists()) {
            File file;
            return BoxesRunTime.boxToBoolean(file.delete());
        }
        return BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$remoteKeepErrors$2(Downloader $this, Either e$1, File errFile0$1) {
        void var2_2;
        ArtifactError.NotFound notFound;
        Left left;
        ArtifactError nf;
        Either either = e$1;
        if (either instanceof Left && (nf = (ArtifactError)(left = (Left)either).value()) instanceof ArtifactError.NotFound && (notFound = (ArtifactError.NotFound)nf).permanent().contains(BoxesRunTime.boxToBoolean(true))) {
            Downloader downloader;
            downloader.createErrFileBlocking$1(errFile0$1);
            return left;
        }
        Downloader.deleteErrFileBlocking$1((File)var2_2);
        return either;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$checkFileExists$1(Downloader $this, File file$7, String url$7) {
        void var1_1;
        void var2_2;
        if ($this.checkFileExistsBlocking(file$7, (String)var2_2)) {
            return new Right(BoxedUnit.UNIT);
        }
        return new Left(new ArtifactError.NotFound(var1_1.toString(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$4(BoxedUnit x$18) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$2(Downloader $this, File file$8, String url$8, boolean keepHeaderChecksums$3, boolean needsUpdate) {
        Downloader downloader;
        void var1_1;
        void var3_3;
        void var2_2;
        Object f = needsUpdate ? $this.remoteKeepErrors(file$8, (String)var2_2, (boolean)var3_3, () -> {
            void var1_1;
            return $this.shouldDownloadSecondCheckBlocking((File)var1_1);
        }) : $this.S().point(new Right(BoxedUnit.UNIT));
        return new EitherT(var1_1).map((Function1<BoxedUnit, Object> & Serializable)x$18 -> {
            Downloader.$anonfun$downloadUrl$4(x$18);
            return BoxedUnit.UNIT;
        }, downloader.S());
    }

    /*
     * WARNING - void declaration
     */
    private final EitherT maybeUpdate$1(File file$8, String url$8, boolean keepHeaderChecksums$3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.shouldDownload(file$8, url$8, true).flatMap(arg_0 -> Downloader.$anonfun$downloadUrl$2$adapted(this, (File)var1_1, (String)var2_2, (boolean)var3_3, arg_0), this.S());
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$6(BoxedUnit x$19) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$5(Downloader $this, File file$8, String url$8, boolean keepHeaderChecksums$3, BoxedUnit x$20) {
        Downloader downloader;
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.maybeUpdate$1((File)var1_1, (String)var2_2, (boolean)var3_3).map((Function1<BoxedUnit, Object> & Serializable)x$19 -> {
            Downloader.$anonfun$downloadUrl$6(x$19);
            return BoxedUnit.UNIT;
        }, downloader.S());
    }

    public static final /* synthetic */ void $anonfun$downloadUrl$9(BoxedUnit x$21) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$8(Downloader $this, File file$8, boolean needsUpdate) {
        Downloader downloader;
        void var1_1;
        Either e = needsUpdate ? new Left(new ArtifactError.FileTooOldOrNotFound(file$8.toString())) : new Right(BoxedUnit.UNIT);
        return new EitherT($this.S().point(var1_1)).map((Function1<BoxedUnit, Object> & Serializable)x$21 -> {
            Downloader.$anonfun$downloadUrl$9(x$21);
            return BoxedUnit.UNIT;
        }, downloader.S());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$7(Downloader $this, File file$8, String url$8, BoxedUnit x$22) {
        Downloader downloader;
        void var1_1;
        void var2_2;
        return $this.shouldDownload(file$8, (String)var2_2, false).flatMap(arg_0 -> Downloader.$anonfun$downloadUrl$8$adapted($this, (File)var1_1, arg_0), downloader.S());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$downloadUrl$11(Downloader $this, File file$8, String url$8) {
        void var2_2;
        void var1_1;
        return !$this.checkFileExistsBlocking((File)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Object run$1(String url$8, File file$8, boolean keepHeaderChecksums$3) {
        if (((String)((Object)url$8)).startsWith("file:/") && !this.localArtifactsShouldBeCached()) {
            return this.checkFileExists(file$8, (String)((Object)url$8), this.checkFileExists$default$3());
        }
        CachePolicy.Mixed mixed = this.actualCachePolicy();
        if (CachePolicy$LocalOnly$.MODULE$.equals(mixed)) {
            return this.checkFileExists(file$8, (String)((Object)url$8), this.checkFileExists$default$3());
        }
        if (CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$LocalUpdate$.MODULE$.equals(mixed)) {
            url$8 = new EitherT(this.checkFileExists(file$8, (String)((Object)url$8), false)).flatMap(arg_0 -> Downloader.$anonfun$downloadUrl$5(this, file$8, (String)((Object)url$8), keepHeaderChecksums$3, arg_0), this.S());
            return url$8.run();
        }
        if (CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed)) {
            url$8 = new EitherT(this.checkFileExists(file$8, (String)((Object)url$8), false)).flatMap(arg_0 -> Downloader.$anonfun$downloadUrl$7(this, file$8, (String)((Object)url$8), arg_0), this.S());
            return url$8.run();
        }
        if (CachePolicy$UpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$Update$.MODULE$.equals(mixed)) {
            return this.maybeUpdate$1(file$8, (String)((Object)url$8), keepHeaderChecksums$3).run();
        }
        if (CachePolicy$FetchMissing$.MODULE$.equals(mixed)) {
            return new EitherT(this.checkFileExists(file$8, (String)((Object)url$8), this.checkFileExists$default$3())).orElse((Function0<EitherT> & Serializable)() -> {
                void var2_2;
                void var1_1;
                Downloader downloader;
                void var3_3;
                return new EitherT(this.remoteKeepErrors(file$8, (String)((Object)url$8), (boolean)var3_3, () -> Downloader.$anonfun$downloadUrl$11(downloader, (File)var1_1, (String)var2_2)));
            }, this.S()).run();
        }
        if (CachePolicy$ForceDownload$.MODULE$.equals(mixed)) {
            void var3_3;
            void var1_1;
            void var2_2;
            return this.remoteKeepErrors((File)var2_2, (String)var1_1, (boolean)var3_3, () -> true);
        }
        throw new MatchError(mixed);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ DownloadResult $anonfun$downloadUrl$13(String url$8, File file$8, Either e) {
        void var2_2;
        void var1_1;
        String string;
        return DownloadResult$.MODULE$.apply(string, (File)var1_1, var2_2.left().toOption());
    }

    /*
     * WARNING - void declaration
     */
    private final Seq checksumRes$1(String c) {
        void var1_1;
        return (Seq)Option$.MODULE$.option2Iterable(this.artifact().checksumUrls().get((String)var1_1)).toSeq().map((Function1<String, Object> & Serializable)url -> {
            void var1_1;
            return this.downloadUrl((String)var1_1, false);
        });
    }

    public static final /* synthetic */ boolean $anonfun$download$6(char x$23) {
        return x$23 != '-';
    }

    /*
     * WARNING - void declaration
     */
    private final String fallbackUrl$1(String c$2) {
        void var1_1;
        return new StringBuilder(1).append(this.artifact().url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(var1_1.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$23 -> BoxesRunTime.boxToBoolean(Downloader.$anonfun$download$6(BoxesRunTime.unboxToChar(x$23))))).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Seq $anonfun$download$5(Downloader $this, String c$2, File candidate$1, boolean x0$1) {
        void var3_3;
        if (!x0$1) {
            return $this.checksumRes$1(c$2);
        }
        if (x0$1) {
            void var2_2;
            void var1_1;
            Downloader downloader;
            String url = (String)$this.artifact().checksumUrls().getOrElse(c$2, (Function0<String> & Serializable)() -> {
                void var1_1;
                return $this.fallbackUrl$1((String)var1_1);
            });
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{downloader.S().point(DownloadResult$.MODULE$.apply((String)var1_1, (File)var2_2))}));
        }
        throw new MatchError(BoxesRunTime.boxToBoolean((boolean)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Seq $anonfun$download$10(DownloadResult r$1, Seq x$24) {
        void var1_1;
        DownloadResult downloadResult = r$1;
        return (Seq)var1_1.$plus$colon(downloadResult);
    }

    /*
     * WARNING - void declaration
     */
    public Downloader(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, int retryCount, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> S) {
        void var1_1;
        CachePolicy.Mixed mixed;
        void var3_3;
        this.artifact = artifact;
        this.cachePolicy = cachePolicy;
        this.location = var3_3;
        this.actualChecksums = actualChecksums;
        this.allCredentials = allCredentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.bufferSize = bufferSize;
        this.classLoaders = classLoaders;
        this.clock = clock;
        this.retryCount = retryCount;
        this.retryBackoffInitialDelay = retryBackoffInitialDelay2;
        this.retryBackoffMultiplier = retryBackoffMultiplier;
        this.S = S;
        Product.$init$(this);
        this.coursier$cache$internal$Downloader$$retry = new Retry(retryCount, retryBackoffInitialDelay2, retryBackoffMultiplier);
        this.cacheErrors = artifact.changing() && artifact.extra().contains("cache-errors");
        mixed = ((CachePolicy)mixed).acceptChanging();
        this.actualCachePolicy = CachePolicy$UpdateChanging$.MODULE$.equals(mixed) && !artifact.changing() ? CachePolicy$FetchMissing$.MODULE$ : ((CachePolicy$LocalUpdateChanging$.MODULE$.equals(mixed) ? true : CachePolicy$LocalOnlyIfValid$.MODULE$.equals(mixed)) && !var1_1.changing() ? CachePolicy$LocalOnly$.MODULE$ : mixed);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$shouldDownload$8$adapted(Option urlLastModOpt$1, Object fileLastMod) {
        void var1_1;
        return Downloader.$anonfun$shouldDownload$8(urlLastModOpt$1, BoxesRunTime.unboxToLong(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$7$adapted(Option fileLastModOpt$1, Option urlLastModOpt) {
        void var1_1;
        return BoxesRunTime.boxToBoolean(Downloader.$anonfun$shouldDownload$7(fileLastModOpt$1, (Option)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$13$adapted(Downloader $this, boolean checkRemote$1, File file$5, String url$5, Object x0$2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Downloader.$anonfun$shouldDownload$13($this, (boolean)var1_1, (File)var2_2, (String)var3_3, BoxesRunTime.unboxToBoolean(x0$2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$shouldDownload$12$adapted(Downloader $this, File file$5, boolean checkRemote$1, String url$5, Object x0$1) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Downloader.$anonfun$shouldDownload$12($this, (File)var1_1, (boolean)var2_2, (String)var3_3, BoxesRunTime.unboxToBoolean(x0$1));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$2$adapted(Downloader $this, File file$8, String url$8, boolean keepHeaderChecksums$3, Object needsUpdate) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Downloader.$anonfun$downloadUrl$2($this, (File)var1_1, (String)var2_2, (boolean)var3_3, BoxesRunTime.unboxToBoolean(needsUpdate));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$downloadUrl$8$adapted(Downloader $this, File file$8, Object needsUpdate) {
        void var2_2;
        void var1_1;
        return Downloader.$anonfun$downloadUrl$8($this, (File)var1_1, BoxesRunTime.unboxToBoolean(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Seq $anonfun$download$5$adapted(Downloader $this, String c$2, File candidate$1, Object x0$1) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Downloader.$anonfun$download$5($this, (String)var1_1, (File)var2_2, BoxesRunTime.unboxToBoolean(var3_3));
    }
}

