import re
from _typeshed import ConvertibleToInt
from collections.abc import Callable, Sequence
from datetime import date, datetime, time, timedelta
from typing import Any, Literal

class ValidationError(ValueError): ...

def check_ip(s: str) -> str: ...
def check_positive(s: ConvertibleToInt) -> int: ...
def check_identifier(s: str) -> str: ...

isbn_re: re.Pattern[str]

def isbn10_checksum(digits: Sequence[ConvertibleToInt]) -> str: ...
def isbn13_checksum(digits: Sequence[ConvertibleToInt]) -> str: ...
def check_isbn(s: str, convert_to: Literal[10, 13] | None = None) -> str: ...
def isbn10_to_isbn13(s: str) -> str: ...
def isbn13_to_isbn10(s: str) -> str: ...

email_re: re.Pattern[str]
rfc2822_email_re: re.Pattern[str]

def check_email(s: str) -> str: ...
def check_rfc2822_email(s: str) -> str: ...

date_str_list: list[str]
date_re_list: list[re.Pattern[str]]
time_str: str
time_re: re.Pattern[str]
datetime_re_list: list[re.Pattern[str]]
month_lists: list[list[str]]
month_list: list[str]
i: int
month: str
month_dict: dict[str, int]

def str2date(s: str) -> date: ...
def str2time(s: str) -> time: ...
def str2datetime(s: str) -> datetime: ...
def str2timedelta(s: str) -> timedelta: ...
def timedelta2str(td: timedelta) -> str: ...

converters: dict[type | str, tuple[Callable[[str], Any], type[str], str | None]]  # Any type from types above

def str2py(
    value: str, type: str | type | tuple[Callable[[str], Any], type[str], str | None] | None
) -> Any: ...  # Any type from types above
