/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.parameter.textembedding;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.MLAlgoParameter;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.input.parameter.textembedding.SparseEmbeddingFormat;

@MLAlgoParameter(algorithms={FunctionName.TEXT_EMBEDDING, FunctionName.SPARSE_ENCODING, FunctionName.SPARSE_TOKENIZE})
public class AsymmetricTextEmbeddingParameters
implements MLAlgoParams {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> AsymmetricTextEmbeddingParameters.parse(it));
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY_SPARSE_ENCODING = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(FunctionName.SPARSE_ENCODING.name(), new String[0]), it -> AsymmetricTextEmbeddingParameters.parse(it));
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY_SPARSE_TOKENIZE = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(FunctionName.SPARSE_TOKENIZE.name(), new String[0]), it -> AsymmetricTextEmbeddingParameters.parse(it));
    public static final String EMBEDDING_CONTENT_TYPE_FIELD = "content_type";
    public static final String SPARSE_EMBEDDING_FORMAT_FIELD = "sparse_embedding_format";
    private EmbeddingContentType embeddingContentType;
    private SparseEmbeddingFormat sparseEmbeddingFormat;

    public AsymmetricTextEmbeddingParameters(EmbeddingContentType embeddingContentType, SparseEmbeddingFormat sparseEmbeddingFormat) {
        this.embeddingContentType = embeddingContentType;
        this.sparseEmbeddingFormat = sparseEmbeddingFormat != null ? sparseEmbeddingFormat : SparseEmbeddingFormat.WORD;
    }

    public AsymmetricTextEmbeddingParameters(EmbeddingContentType embeddingContentType) {
        this.embeddingContentType = embeddingContentType;
        this.sparseEmbeddingFormat = SparseEmbeddingFormat.WORD;
    }

    public AsymmetricTextEmbeddingParameters(StreamInput in) throws IOException {
        String formatName;
        Version streamInputVersion = in.getVersion();
        String contentType = in.readOptionalString();
        EmbeddingContentType embeddingContentType = this.embeddingContentType = contentType != null ? EmbeddingContentType.valueOf(contentType) : null;
        this.sparseEmbeddingFormat = streamInputVersion.onOrAfter(Version.V_3_2_0) ? ((formatName = in.readOptionalString()) != null ? SparseEmbeddingFormat.valueOf(formatName) : SparseEmbeddingFormat.WORD) : SparseEmbeddingFormat.WORD;
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        EmbeddingContentType embeddingContentType = null;
        SparseEmbeddingFormat sparseEmbeddingFormat = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "content_type": {
                    String contentType = parser.text();
                    embeddingContentType = EmbeddingContentType.valueOf(contentType.toUpperCase(Locale.ROOT));
                    continue block8;
                }
                case "sparse_embedding_format": {
                    String formatType = parser.text();
                    sparseEmbeddingFormat = SparseEmbeddingFormat.valueOf(formatType.toUpperCase(Locale.ROOT));
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new AsymmetricTextEmbeddingParameters(embeddingContentType, sparseEmbeddingFormat);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.embeddingContentType != null ? this.embeddingContentType.name() : null);
        if (streamOutputVersion.onOrAfter(Version.V_3_2_0)) {
            out.writeOptionalString(this.sparseEmbeddingFormat != null ? this.sparseEmbeddingFormat.name() : null);
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject();
        if (this.embeddingContentType != null) {
            xContentBuilder.field(EMBEDDING_CONTENT_TYPE_FIELD, this.embeddingContentType.name());
        }
        xContentBuilder.field(SPARSE_EMBEDDING_FORMAT_FIELD, this.sparseEmbeddingFormat.name());
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    public EmbeddingContentType getEmbeddingContentType() {
        return this.embeddingContentType;
    }

    public SparseEmbeddingFormat getSparseEmbeddingFormat() {
        return this.sparseEmbeddingFormat;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsymmetricTextEmbeddingParameters other = (AsymmetricTextEmbeddingParameters)obj;
        return Objects.equals((Object)this.embeddingContentType, (Object)other.embeddingContentType) && Objects.equals((Object)this.sparseEmbeddingFormat, (Object)other.sparseEmbeddingFormat);
    }

    @Generated
    public static AsymmetricTextEmbeddingParametersBuilder builder() {
        return new AsymmetricTextEmbeddingParametersBuilder();
    }

    @Generated
    public AsymmetricTextEmbeddingParametersBuilder toBuilder() {
        return new AsymmetricTextEmbeddingParametersBuilder().embeddingContentType(this.embeddingContentType).sparseEmbeddingFormat(this.sparseEmbeddingFormat);
    }

    @Generated
    public void setEmbeddingContentType(EmbeddingContentType embeddingContentType) {
        this.embeddingContentType = embeddingContentType;
    }

    @Generated
    public void setSparseEmbeddingFormat(SparseEmbeddingFormat sparseEmbeddingFormat) {
        this.sparseEmbeddingFormat = sparseEmbeddingFormat;
    }

    @Generated
    public String toString() {
        return "AsymmetricTextEmbeddingParameters(embeddingContentType=" + String.valueOf((Object)this.getEmbeddingContentType()) + ", sparseEmbeddingFormat=" + String.valueOf((Object)this.getSparseEmbeddingFormat()) + ")";
    }

    public static enum EmbeddingContentType {
        QUERY,
        PASSAGE;

    }

    @Generated
    public static class AsymmetricTextEmbeddingParametersBuilder {
        @Generated
        private EmbeddingContentType embeddingContentType;
        @Generated
        private SparseEmbeddingFormat sparseEmbeddingFormat;

        @Generated
        AsymmetricTextEmbeddingParametersBuilder() {
        }

        @Generated
        public AsymmetricTextEmbeddingParametersBuilder embeddingContentType(EmbeddingContentType embeddingContentType) {
            this.embeddingContentType = embeddingContentType;
            return this;
        }

        @Generated
        public AsymmetricTextEmbeddingParametersBuilder sparseEmbeddingFormat(SparseEmbeddingFormat sparseEmbeddingFormat) {
            this.sparseEmbeddingFormat = sparseEmbeddingFormat;
            return this;
        }

        @Generated
        public AsymmetricTextEmbeddingParameters build() {
            return new AsymmetricTextEmbeddingParameters(this.embeddingContentType, this.sparseEmbeddingFormat);
        }

        @Generated
        public String toString() {
            return "AsymmetricTextEmbeddingParameters.AsymmetricTextEmbeddingParametersBuilder(embeddingContentType=" + String.valueOf((Object)this.embeddingContentType) + ", sparseEmbeddingFormat=" + String.valueOf((Object)this.sparseEmbeddingFormat) + ")";
        }
    }
}

