/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.opensearch.knn.memoryoptsearch.faiss.FaissSection;
import org.opensearch.knn.memoryoptsearch.faiss.MonotonicIntegerSequenceEncoder;

public class FaissHNSW {
    private int[] cumNumberNeighborPerLevel;
    private DirectMonotonicReader offsetsReader = null;
    private FaissSection neighbors;
    private FaissSection levels;
    protected int entryPoint;
    protected int maxLevel = -1;
    private int efSearch = 16;
    private long totalNumberOfVectors;

    public void load(IndexInput input, long totalNumberOfVectors) throws IOException {
        this.totalNumberOfVectors = totalNumberOfVectors;
        long size = input.readLong();
        input.skipBytes(8L * size);
        size = input.readLong();
        this.cumNumberNeighborPerLevel = new int[Math.toIntExact(size)];
        if (size > 0L) {
            input.readInts(this.cumNumberNeighborPerLevel, 0, (int)size);
        }
        this.levels = new FaissSection(input, 4);
        size = input.readLong();
        this.offsetsReader = MonotonicIntegerSequenceEncoder.encode(Math.toIntExact(size), input);
        Objects.requireNonNull(this.offsetsReader);
        this.neighbors = new FaissSection(input, 4);
        this.entryPoint = input.readInt();
        this.maxLevel = input.readInt();
        input.readInt();
        this.efSearch = input.readInt();
        input.readInt();
    }

    public int getMaxNumNeighbors() {
        if (this.cumNumberNeighborPerLevel != null && this.cumNumberNeighborPerLevel.length >= 1) {
            return this.cumNumberNeighborPerLevel[1];
        }
        return 0;
    }

    @Generated
    public int[] getCumNumberNeighborPerLevel() {
        return this.cumNumberNeighborPerLevel;
    }

    @Generated
    public DirectMonotonicReader getOffsetsReader() {
        return this.offsetsReader;
    }

    @Generated
    public FaissSection getNeighbors() {
        return this.neighbors;
    }

    @Generated
    public FaissSection getLevels() {
        return this.levels;
    }

    @Generated
    public int getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public int getEfSearch() {
        return this.efSearch;
    }

    @Generated
    public long getTotalNumberOfVectors() {
        return this.totalNumberOfVectors;
    }
}

