/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandlerv2;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.actionv2.IndexMonitorV2Action;
import org.opensearch.alerting.actionv2.IndexMonitorV2Request;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.resthandlerv2.RestIndexMonitorV2ActionKt;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/alerting/resthandlerv2/RestIndexMonitorV2Action;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-alerting"})
public final class RestIndexMonitorV2Action
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_monitor_v2_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_V2_BASE_URI), new RestHandler.Route(RestRequest.Method.PUT, AlertingPlugin.MONITOR_V2_BASE_URI + "/{monitor_id}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestIndexMonitorV2ActionKt.access$getLog$p().debug(request.method() + " " + request.path());
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        MonitorV2 monitorV2 = null;
        List rbacRoles = null;
        try {
            Intrinsics.checkNotNull((Object)xcp);
            monitorV2 = MonitorV2.Companion.parse$default(MonitorV2.Companion, xcp, null, 0L, 6, null);
            rbacRoles = (List)request.contentParser().map().get("rbac_roles");
        }
        catch (Exception e) {
            throw AlertingException.Companion.wrap((Exception)new IllegalArgumentException(e.getLocalizedMessage()));
        }
        String id = request.param("monitor_id", "");
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNull((Object)id);
        Intrinsics.checkNotNull((Object)refreshPolicy);
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        IndexMonitorV2Request indexMonitorV2Request = new IndexMonitorV2Request(id, seqNo, primaryTerm, refreshPolicy, method, monitorV2, rbacRoles);
        return arg_0 -> RestIndexMonitorV2Action.prepareRequest$lambda$0(client, indexMonitorV2Request, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexMonitorV2Request $indexMonitorV2Request, RestChannel channel) {
        $client.execute((ActionType)IndexMonitorV2Action.Companion.getINSTANCE(), (ActionRequest)$indexMonitorV2Request, (ActionListener)new RestToXContentListener(channel));
    }
}

