/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.ee8.nested.AsyncContextEvent;
import org.eclipse.jetty.ee8.nested.CrossContextServletContext;
import org.eclipse.jetty.ee8.nested.Dispatcher;
import org.eclipse.jetty.ee8.nested.ErrorHandler;
import org.eclipse.jetty.ee8.nested.Handler;
import org.eclipse.jetty.ee8.nested.HandlerWrapper;
import org.eclipse.jetty.ee8.nested.HttpChannel;
import org.eclipse.jetty.ee8.nested.HttpChannelState;
import org.eclipse.jetty.ee8.nested.ManagedAttributeListener;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.ee8.nested.Response;
import org.eclipse.jetty.ee8.nested.ScopedHandler;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.IOResources;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="EE8 Context")
public class ContextHandler
extends ScopedHandler
implements Attributes,
Supplier<org.eclipse.jetty.server.Handler> {
    public static final Environment ENVIRONMENT = Environment.ensure((String)"ee8");
    public static final int SERVLET_MAJOR_VERSION = 4;
    public static final int SERVLET_MINOR_VERSION = 0;
    public static final Class<?>[] SERVLET_LISTENER_TYPES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
    public static final int DEFAULT_LISTENER_TYPE_INDEX = 1;
    public static final int EXTENDED_LISTENER_TYPE_INDEX = 0;
    private static final String UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER = "Unimplemented {} - use org.eclipse.jetty.servlet.ServletContextHandler";
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandler.class);
    private static final ThreadLocal<APIContext> __context = new ThreadLocal();
    private static String __serverInfo = "jetty/" + Server.getVersion();
    public static final String MAX_FORM_KEYS_KEY = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_FORM_CONTENT_SIZE_KEY = "org.eclipse.jetty.server.Request.maxFormContentSize";
    public static final int DEFAULT_MAX_FORM_KEYS = 1000;
    public static final int DEFAULT_MAX_FORM_CONTENT_SIZE = 200000;
    private boolean _canonicalEncodingURIs = false;
    private boolean _usingSecurityManager = ContextHandler.getSecurityManager() != null;
    private final CoreContextHandler _coreContextHandler;
    protected ContextStatus _contextStatus = ContextStatus.NOTSET;
    protected APIContext _apiContext;
    private final Map<String, String> _initParams;
    private String _defaultRequestCharacterEncoding;
    private String _defaultResponseCharacterEncoding;
    private String _contextPathEncoded = "/";
    private Map<String, String> _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private Logger _logger;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", 1000);
    private int _maxFormContentSize = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 200000);
    private boolean _compactPath = false;
    private final List<EventListener> _programmaticListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<ServletContextListener> _servletContextListeners = new CopyOnWriteArrayList<ServletContextListener>();
    private final List<ServletContextListener> _destroyServletContextListeners = new ArrayList<ServletContextListener>();
    private final List<ServletContextAttributeListener> _servletContextAttributeListeners = new CopyOnWriteArrayList<ServletContextAttributeListener>();
    private final List<ServletRequestListener> _servletRequestListeners = new CopyOnWriteArrayList<ServletRequestListener>();
    private final List<ServletRequestAttributeListener> _servletRequestAttributeListeners = new CopyOnWriteArrayList<ServletRequestAttributeListener>();
    private final List<ContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ContextScopeListener>();
    private final Set<EventListener> _durableListeners = new HashSet<EventListener>();

    public static APIContext getCurrentContext() {
        return __context.get();
    }

    public static ContextHandler getCurrentContextHandler() {
        APIContext c = ContextHandler.getCurrentContext();
        if (c != null) {
            return c.getContextHandler();
        }
        return null;
    }

    public static ContextHandler getContextHandler(ServletContext context) {
        if (context instanceof APIContext) {
            return ((APIContext)context).getContextHandler();
        }
        return ContextHandler.getCurrentContextHandler();
    }

    public static ServletContext getServletContext(Context context) {
        if (context instanceof CoreContextHandler.CoreContext) {
            CoreContextHandler.CoreContext coreContext = (CoreContextHandler.CoreContext)context;
            return coreContext.getAPIContext();
        }
        return null;
    }

    public ContextHandler() {
        this(null, null, null);
        Objects.requireNonNull(ENVIRONMENT);
    }

    public ContextHandler(String contextPath) {
        this(null, null, contextPath);
    }

    public ContextHandler(String contextPath, Handler handler) {
        this(contextPath);
        this.setHandler(handler);
    }

    public ContextHandler(Handler.Container parent) {
        this(null, parent, "/");
    }

    public ContextHandler(Handler.Container parent, String contextPath) {
        this(null, parent, contextPath);
    }

    protected ContextHandler(APIContext context, Handler.Container parent, String contextPath) {
        this._coreContextHandler = new CoreContextHandler();
        this.installBean((Object)this._coreContextHandler, false);
        this._apiContext = context == null ? new APIContext() : context;
        this._initParams = new HashMap<String, String>();
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        HandlerWrapper.setAsParent(parent, (org.eclipse.jetty.server.Handler)this._coreContextHandler);
    }

    @Override
    public org.eclipse.jetty.server.Handler get() {
        return this._coreContextHandler;
    }

    public CoreContextHandler getCoreContextHandler() {
        return this._coreContextHandler;
    }

    public void insertHandler(Handler.Singleton coreHandler) {
        this.getCoreContextHandler().insertHandler(coreHandler);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{Dumpable.named((String)"maxFormKeys ", (Object)this.getMaxFormKeys()), Dumpable.named((String)"maxFormContentSize ", (Object)this.getMaxFormContentSize()), new DumpableCollection("initparams " + String.valueOf(this), this.getInitParams().entrySet())});
    }

    public APIContext getServletContext() {
        return this._apiContext;
    }

    @ManagedAttribute(value="Checks if the /context is not redirected to /context/")
    public boolean getAllowNullPathInfo() {
        return this._coreContextHandler.getAllowNullPathInContext();
    }

    public void setAllowNullPathInfo(boolean allowNullPathInfo) {
        this._coreContextHandler.setAllowNullPathInContext(allowNullPathInfo);
    }

    public void setCrossContextDispatchSupported(boolean supported) {
        this.getCoreContextHandler().setCrossContextDispatchSupported(supported);
    }

    public boolean isCrossContextDispatchSupported() {
        return this.getCoreContextHandler().isCrossContextDispatchSupported();
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        if (!Objects.equals(server, this._coreContextHandler.getServer())) {
            this._coreContextHandler.setServer(server);
        }
        if (this._errorHandler != null) {
            this._errorHandler.setServer(server);
        }
    }

    public boolean isUsingSecurityManager() {
        return this._usingSecurityManager;
    }

    public void setUsingSecurityManager(boolean usingSecurityManager) {
        if (usingSecurityManager && ContextHandler.getSecurityManager() == null) {
            throw new IllegalStateException("No security manager");
        }
        this._usingSecurityManager = usingSecurityManager;
    }

    public void setVirtualHosts(String[] vhosts) {
        this._coreContextHandler.setVirtualHosts(vhosts == null ? Collections.emptyList() : Arrays.asList(vhosts));
    }

    public void addVirtualHosts(String[] virtualHosts) {
        this._coreContextHandler.addVirtualHosts(virtualHosts);
    }

    public void removeVirtualHosts(String[] virtualHosts) {
        this._coreContextHandler.removeVirtualHosts(virtualHosts);
    }

    @ManagedAttribute(value="Virtual hosts accepted by the context", readonly=true)
    public String[] getVirtualHosts() {
        return this._coreContextHandler.getVirtualHosts().toArray(new String[0]);
    }

    public Object getAttribute(String name) {
        return this._coreContextHandler.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeNameSet());
    }

    public Set<String> getAttributeNameSet() {
        return this._coreContextHandler.getAttributeNameSet();
    }

    public Attributes getAttributes() {
        return this._coreContextHandler;
    }

    public ClassLoader getClassLoader() {
        return this._coreContextHandler.getClassLoader();
    }

    @ManagedAttribute(value="The file classpath")
    public String getClassPath() {
        return this._coreContextHandler.getClassPath();
    }

    @ManagedAttribute(value="True if URLs are compacted to replace the multiple '/'s with a single '/'")
    public String getContextPath() {
        return this._coreContextHandler.getContextPath();
    }

    public String getContextPathEncoded() {
        return this._contextPathEncoded;
    }

    public String getRequestContextPath() {
        String contextPathEncoded = this.getContextPathEncoded();
        return "/".equals(contextPathEncoded) ? "" : contextPathEncoded;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public String setInitParameter(String name, String value) {
        return this._initParams.put(name, value);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameter map for the context")
    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    @ManagedAttribute(value="Display name of the Context", readonly=true)
    public String getDisplayName() {
        return this._coreContextHandler.getDisplayName();
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                ContextScopeListener contextScopeListener = (ContextScopeListener)listener;
                this._contextListeners.add(contextScopeListener);
                if (__context.get() != null) {
                    contextScopeListener.enterScope(__context.get(), null, "Listener registered");
                }
            }
            if (listener instanceof ServletContextListener) {
                ServletContextListener servletContextListener = (ServletContextListener)listener;
                if (this._contextStatus == ContextStatus.INITIALIZED) {
                    this._destroyServletContextListeners.add(servletContextListener);
                    if (this.isStarting()) {
                        LOG.warn("ContextListener {} added whilst starting {}", (Object)servletContextListener, (Object)this);
                        this.callContextInitialized(servletContextListener, new ServletContextEvent((ServletContext)this._apiContext));
                    } else {
                        LOG.warn("ContextListener {} added after starting {}", (Object)servletContextListener, (Object)this);
                    }
                }
                this._servletContextListeners.add((ServletContextListener)listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)listener;
                this._servletContextAttributeListeners.add(servletContextAttributeListener);
            }
            if (listener instanceof ServletRequestListener) {
                ServletRequestListener servletRequestListener = (ServletRequestListener)listener;
                this._servletRequestListeners.add(servletRequestListener);
            }
            if (listener instanceof ServletRequestAttributeListener) {
                ServletRequestAttributeListener servletRequestAttributeListener = (ServletRequestAttributeListener)listener;
                this._servletRequestAttributeListeners.add(servletRequestAttributeListener);
            }
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                this._contextListeners.remove(listener);
            }
            if (listener instanceof ServletContextListener) {
                this._servletContextListeners.remove(listener);
                this._destroyServletContextListeners.remove(listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._servletContextAttributeListeners.remove(listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._servletRequestListeners.remove(listener);
            }
            if (listener instanceof ServletRequestAttributeListener) {
                this._servletRequestAttributeListeners.remove(listener);
            }
            return true;
        }
        return false;
    }

    protected void addProgrammaticListener(EventListener listener) {
        this._programmaticListeners.add(listener);
    }

    public boolean isProgrammaticListener(EventListener listener) {
        return this._programmaticListeners.contains(listener);
    }

    public boolean isDurableListener(EventListener listener) {
        if (this.isStarted()) {
            return this._durableListeners.contains(listener);
        }
        return this.getEventListeners().contains(listener);
    }

    public boolean isAvailable() {
        return this._coreContextHandler.isAvailable();
    }

    public void setAvailable(boolean available) {
        this._coreContextHandler.setAvailable(available);
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    @Override
    protected void doStart() throws Exception {
        if (org.eclipse.jetty.server.handler.ContextHandler.getCurrentContext() != this._coreContextHandler.getContext()) {
            this._coreContextHandler.unmanage(this);
            this._coreContextHandler.addEventListener((EventListener)new LifeCycle.Listener(){

                public void lifeCycleStarting(LifeCycle event) {
                    try {
                        ContextHandler.this._coreContextHandler.getContext().call(() -> ContextHandler.this.doStartInContext(), null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void lifeCycleStarted(LifeCycle event) {
                    ContextHandler.this._coreContextHandler.manage(this);
                    ContextHandler.this._coreContextHandler.removeEventListener((EventListener)((Object)this));
                }
            });
            this._coreContextHandler.start();
            return;
        }
        this._coreContextHandler.getContext().call(this::doStartInContext, null);
    }

    protected void doStartInContext() throws Exception {
        if (this._logger == null) {
            this._logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + this.getLogNameSuffix()));
        }
        if (this._errorHandler == null) {
            this.setErrorHandler(new ErrorHandler());
        }
        this.setAttribute("org.eclipse.jetty.server.Executor", this.getServer().getThreadPool());
        this._durableListeners.addAll(this.getEventListeners());
        this.startContext();
        this.contextInitialized();
    }

    @Override
    protected void doStop() throws Exception {
        if (org.eclipse.jetty.server.handler.ContextHandler.getCurrentContext() != this._coreContextHandler.getContext()) {
            this._coreContextHandler.unmanage(this);
            this._coreContextHandler.addEventListener((EventListener)new LifeCycle.Listener(){

                public void lifeCycleStopping(LifeCycle event) {
                    try {
                        ContextHandler.this._coreContextHandler.getContext().call(() -> ContextHandler.this.doStopInContext(), null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void lifeCycleStopped(LifeCycle event) {
                    ContextHandler.this._coreContextHandler.manage(this);
                    ContextHandler.this._coreContextHandler.removeEventListener((EventListener)((Object)this));
                }
            });
            this._coreContextHandler.stop();
            return;
        }
        this._coreContextHandler.getContext().call(this::doStopInContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStopInContext() throws Exception {
        try {
            this.stopContext();
            this.contextDestroyed();
            this.setEventListeners(this._durableListeners);
            this._durableListeners.clear();
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
            for (EventListener l : this._programmaticListeners) {
                this.removeEventListener(l);
                if (!(l instanceof ContextScopeListener)) continue;
                try {
                    ((ContextScopeListener)l).exitScope(this._apiContext, null);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to exit scope", e);
                }
            }
            this._programmaticListeners.clear();
        }
        finally {
            this._contextStatus = ContextStatus.NOTSET;
        }
    }

    private String getLogNameSuffix() {
        String logName = this.getDisplayName();
        if (StringUtil.isBlank((String)logName)) {
            logName = this.getContextPath();
            if (logName != null && logName.startsWith("/")) {
                logName = logName.substring(1);
            }
            if (StringUtil.isBlank((String)logName)) {
                logName = "ROOT";
            }
        }
        return "." + logName.replaceAll("\\W", "_");
    }

    protected void startContext() throws Exception {
        String managedAttributes = this._initParams.get("org.eclipse.jetty.server.context.ManagedAttributes");
        if (managedAttributes != null) {
            this.addEventListener((EventListener)((Object)new ManagedAttributeListener(this, StringUtil.csvSplit((String)managedAttributes))));
        }
        super.doStart();
    }

    public void contextInitialized() throws Exception {
        if (this._contextStatus == ContextStatus.NOTSET) {
            this._contextStatus = ContextStatus.INITIALIZED;
            this._destroyServletContextListeners.clear();
            if (!this._servletContextListeners.isEmpty()) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this._apiContext);
                for (ServletContextListener listener : this._servletContextListeners) {
                    this.callContextInitialized(listener, event);
                    this._destroyServletContextListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed() throws Exception {
        switch (this._contextStatus.ordinal()) {
            case 1: {
                try {
                    Throwable multiException = null;
                    ServletContextEvent event = new ServletContextEvent((ServletContext)this._apiContext);
                    Collections.reverse(this._destroyServletContextListeners);
                    for (ServletContextListener listener : this._destroyServletContextListeners) {
                        try {
                            this.callContextDestroyed(listener, event);
                        }
                        catch (Exception x) {
                            multiException = ExceptionUtil.combine(multiException, (Throwable)x);
                        }
                    }
                    ExceptionUtil.ifExceptionThrow(multiException);
                    break;
                }
                finally {
                    this._contextStatus = ContextStatus.DESTROYED;
                }
            }
        }
    }

    protected void stopContext() throws Exception {
        super.doStop();
    }

    protected void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        if (this.getServer().isDryRun()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextInitialized: {}->{}", (Object)e, (Object)l);
        }
        l.contextInitialized(e);
    }

    protected void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        if (this.getServer().isDryRun()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextDestroyed: {}->{}", (Object)e, (Object)l);
        }
        l.contextDestroyed(e);
    }

    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope {}|{}|{} @ {}", new Object[]{baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), this});
        }
        APIContext oldContext = baseRequest.getContext();
        String oldPathInContext = baseRequest.getPathInContext();
        String pathInContext = target;
        DispatcherType dispatch = baseRequest.getDispatcherType();
        if (oldContext != this._apiContext) {
            String contextPath = this.getContextPath();
            if (DispatcherType.REQUEST.equals((Object)dispatch) || DispatcherType.ASYNC.equals((Object)dispatch) || baseRequest.getCoreRequest().getContext().isCrossContextDispatch((org.eclipse.jetty.server.Request)baseRequest.getCoreRequest())) {
                if (this.isCompactPath()) {
                    target = URIUtil.compactPath((String)target);
                }
                if (target.length() > contextPath.length()) {
                    if (contextPath.length() > 1) {
                        target = target.substring(contextPath.length());
                    }
                    pathInContext = target;
                } else if (contextPath.length() == 1) {
                    target = "/";
                    pathInContext = "/";
                } else {
                    target = "/";
                    pathInContext = null;
                }
            }
        }
        try {
            baseRequest.setContext(this._apiContext, DispatcherType.INCLUDE.equals((Object)dispatch) || !target.startsWith("/") ? oldPathInContext : pathInContext);
            ContextHandler.ScopedContext context = this.getCoreContextHandler().getContext();
            if (context == org.eclipse.jetty.server.handler.ContextHandler.getCurrentContext()) {
                this.nextScope(target, baseRequest, request, response);
            } else {
                String t = target;
                context.call(() -> this.nextScope(t, baseRequest, request, response), (org.eclipse.jetty.server.Request)baseRequest.getCoreRequest());
            }
        }
        catch (IOException | RuntimeException | ServletException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServletException("Unexpected Exception", t);
        }
        finally {
            baseRequest.setContext(oldContext, oldPathInContext);
        }
    }

    protected void requestInitialized(Request baseRequest, HttpServletRequest request) {
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            for (ServletRequestAttributeListener l : this._servletRequestAttributeListeners) {
                baseRequest.addEventListener((EventListener)l);
            }
        }
        if (!this._servletRequestListeners.isEmpty()) {
            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._apiContext, (ServletRequest)request);
            for (ServletRequestListener l : this._servletRequestListeners) {
                l.requestInitialized(sre);
            }
        }
    }

    protected void requestDestroyed(Request baseRequest, HttpServletRequest request) {
        if (!this._servletRequestListeners.isEmpty()) {
            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._apiContext, (ServletRequest)request);
            ListIterator i = TypeUtil.listIteratorAtEnd(this._servletRequestListeners);
            while (i.hasPrevious()) {
                ((ServletRequestListener)i.previous()).requestDestroyed(sre);
            }
        }
        if (!this._servletRequestAttributeListeners.isEmpty()) {
            ListIterator i = TypeUtil.listIteratorAtEnd(this._servletRequestAttributeListeners);
            while (i.hasPrevious()) {
                baseRequest.removeEventListener((EventListener)i.previous());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType dispatch = baseRequest.getDispatcherType();
        boolean new_context = dispatch == DispatcherType.REQUEST;
        try {
            if (new_context) {
                this.requestInitialized(baseRequest, request);
            }
            if (new_context && this._coreContextHandler.isProtectedTarget(target)) {
                baseRequest.setHandled(true);
                response.sendError(404);
                return;
            }
            this.nextHandle(target, baseRequest, request, response);
        }
        finally {
            if (new_context) {
                this.requestDestroyed(baseRequest, request);
            }
        }
    }

    protected void enterScope(Request request, Object reason) {
        if (!this._contextListeners.isEmpty()) {
            for (ContextScopeListener listener : this._contextListeners) {
                try {
                    listener.enterScope(this._apiContext, request, reason);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to enter scope", e);
                }
            }
        }
    }

    protected void exitScope(Request request) {
        if (!this._contextListeners.isEmpty()) {
            ListIterator i = TypeUtil.listIteratorAtEnd(this._contextListeners);
            while (i.hasPrevious()) {
                try {
                    ((ContextScopeListener)i.previous()).exitScope(this._apiContext, request);
                }
                catch (Throwable e) {
                    LOG.warn("Unable to exit scope", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Runnable runnable) {
        APIContext oldContext = __context.get();
        if (oldContext == this._apiContext) {
            runnable.run();
            return;
        }
        try {
            __context.set(this._apiContext);
            this._apiContext._coreContext.run(runnable, (org.eclipse.jetty.server.Request)request.getHttpChannel().getCoreRequest());
        }
        finally {
            __context.set(null);
        }
    }

    public void handle(Runnable runnable) {
        this.handle(null, runnable);
    }

    public boolean isProtectedTarget(String target) {
        return this._coreContextHandler.isProtectedTarget(target);
    }

    public void setProtectedTargets(String[] targets) {
        this._coreContextHandler.setProtectedTargets(targets);
    }

    public String[] getProtectedTargets() {
        return this._coreContextHandler.getProtectedTargets();
    }

    public Object removeAttribute(String name) {
        return this._coreContextHandler.removeAttribute(name);
    }

    public Object setAttribute(String name, Object value) {
        return this._coreContextHandler.setAttribute(name, value);
    }

    public void setAttributes(Attributes attributes) {
        this._coreContextHandler.clearAttributes();
        for (String n : attributes.getAttributeNameSet()) {
            this._coreContextHandler.setAttribute(n, attributes.getAttribute(n));
        }
    }

    public void clearAttributes() {
        this._coreContextHandler.clearAttributes();
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._coreContextHandler.setClassLoader(classLoader);
    }

    public void setDefaultRequestCharacterEncoding(String encoding) {
        this._defaultRequestCharacterEncoding = encoding;
    }

    public String getDefaultRequestCharacterEncoding() {
        return this._defaultRequestCharacterEncoding;
    }

    public void setDefaultResponseCharacterEncoding(String encoding) {
        this._defaultResponseCharacterEncoding = encoding;
    }

    public String getDefaultResponseCharacterEncoding() {
        return this._defaultResponseCharacterEncoding;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("null contextPath");
        }
        if (contextPath.endsWith("/*")) {
            LOG.warn("{} contextPath ends with /*", (Object)this);
            contextPath = contextPath.substring(0, contextPath.length() - 2);
        } else if (contextPath.length() > 1 && contextPath.endsWith("/")) {
            LOG.warn("{} contextPath ends with /", (Object)this);
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        if (contextPath.length() == 0) {
            LOG.warn("Empty contextPath");
            contextPath = "/";
        }
        this._coreContextHandler.setContextPath(contextPath);
    }

    public void setDisplayName(String displayName) {
        this._coreContextHandler.setDisplayName(displayName);
    }

    @ManagedAttribute(value="document root for context")
    public Resource getBaseResource() {
        return this._coreContextHandler.getBaseResource();
    }

    @Deprecated
    public String getResourceBase() {
        Resource resourceBase = this._coreContextHandler.getBaseResource();
        return resourceBase == null ? null : resourceBase.toString();
    }

    public void setBaseResource(Resource base) {
        this._coreContextHandler.setBaseResource(base);
    }

    public void setBaseResourceAsPath(Path base) {
        this._coreContextHandler.setBaseResourceAsPath(base);
    }

    public void setBaseResourceAsString(String base) {
        this._coreContextHandler.setBaseResourceAsString(base);
    }

    @Deprecated
    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(this.newResource(resourceBase));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to set baseResource: {}", (Object)resourceBase, (Object)e);
            } else {
                LOG.warn(e.toString());
            }
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public MimeTypes.Mutable getMimeTypes() {
        return this._coreContextHandler.getMimeTypes();
    }

    public void setWelcomeFiles(String[] files) {
        this._welcomeFiles = files;
    }

    @ManagedAttribute(value="Partial URIs of directory welcome files", readonly=true)
    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    @ManagedAttribute(value="The error handler to use for the context")
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        this.updateBean(this._errorHandler, errorHandler, true);
        this._errorHandler = errorHandler;
    }

    @ManagedAttribute(value="The maximum content size")
    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxSize) {
        this._maxFormContentSize = maxSize;
    }

    public int getMaxFormKeys() {
        return this._maxFormKeys;
    }

    public void setMaxFormKeys(int max) {
        this._maxFormKeys = max;
    }

    @Deprecated(since="10.0.5", forRemoval=true)
    public boolean isCompactPath() {
        return this._compactPath;
    }

    @Deprecated(since="10.0.5", forRemoval=true)
    public void setCompactPath(boolean compactPath) {
        this._compactPath = compactPath;
    }

    public String toString() {
        if (this._coreContextHandler == null) {
            return "%s@%x.<init>".formatted(TypeUtil.toShortName(ContextHandler.class), this.hashCode());
        }
        String[] vhosts = this.getVirtualHosts();
        StringBuilder b = new StringBuilder();
        b.append(TypeUtil.toShortName(this.getClass())).append('@').append(Integer.toString(this.hashCode(), 16));
        b.append('{');
        if (this.getDisplayName() != null) {
            b.append(this.getDisplayName()).append(',');
        }
        b.append(this.getContextPath()).append(',').append(this.getBaseResource()).append(',').append(this._coreContextHandler.isAvailable());
        if (vhosts != null && vhosts.length > 0) {
            b.append(',').append(vhosts[0]);
        }
        b.append('}');
        return b.toString();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        ClassLoader classLoader = this._apiContext.getCoreContext().getClassLoader();
        if (classLoader == null) {
            return Loader.loadClass((String)className);
        }
        return classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap<String, String>();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(String locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale);
        return encoding;
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Map<String, String> getLocaleEncodings() {
        if (this._localeEncodingMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._localeEncodingMap);
    }

    public Resource getResource(String pathInContext) throws MalformedURLException {
        if (pathInContext == null || !pathInContext.startsWith("/")) {
            throw new MalformedURLException(pathInContext);
        }
        Resource baseResource = this._coreContextHandler.getBaseResource();
        if (baseResource == null) {
            return null;
        }
        try {
            return baseResource.resolve(pathInContext);
        }
        catch (Exception e) {
            LOG.trace("IGNORED", (Throwable)e);
            return null;
        }
    }

    public boolean checkAlias(String path, Resource resource) {
        if (Resources.isReadable((Resource)resource) && resource.isAlias()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Alias resource {} for {}", (Object)resource, (Object)resource.getRealURI());
            }
            for (AliasCheck check : this.getAliasChecks()) {
                if (!check.checkAlias(path, resource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: {} approved by {}", (Object)resource, (Object)check);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public Resource newResource(URL url) throws IOException {
        return ResourceFactory.of((Container)this).newResource(url);
    }

    public Resource newResource(URI uri) throws IOException {
        return ResourceFactory.of((Container)this).newResource(uri);
    }

    public Resource newResource(String uriOrPath) throws IOException {
        return ResourceFactory.of((Container)this).newResource(uriOrPath);
    }

    public Set<String> getResourcePaths(String path) {
        try {
            Resource resource = this.getResource((String)path);
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            HashSet<String> set = new HashSet<String>();
            for (Resource item : resource.list()) {
                String entry = (String)path + item.getFileName();
                if (item.isDirectory()) {
                    entry = entry + "/";
                }
                set.add(entry);
            }
            return set;
        }
        catch (Exception e) {
            LOG.trace("IGNORED", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void addAliasCheck(AliasCheck check) {
        this._coreContextHandler.addAliasCheck(check);
    }

    public List<AliasCheck> getAliasChecks() {
        return this._coreContextHandler.getAliasChecks();
    }

    public void setAliasChecks(List<AliasCheck> checks) {
        this._coreContextHandler.setAliasChecks(checks);
    }

    public void clearAliasChecks() {
        this._coreContextHandler.clearAliasChecks();
    }

    private static Object getSecurityManager() {
        return SecurityUtils.getSecurityManager();
    }

    public void handle(HttpChannel channel) throws IOException, ServletException {
        String target = channel.getRequest().getPathInfo();
        Request request = channel.getRequest();
        Response response = channel.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} ?{} on {}", new Object[]{request.getDispatcherType(), request.getMethod(), target, request.getQueryString(), channel});
        }
        if (HttpMethod.OPTIONS.is(request.getMethod()) || "*".equals(target)) {
            if (!HttpMethod.OPTIONS.is(request.getMethod())) {
                request.setHandled(true);
                response.sendError(400);
            } else {
                this.handleOptions(request, response);
                if (!request.isHandled()) {
                    this.handle(target, request, request, response);
                }
            }
        } else {
            this.handle(target, request, request, response);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handled={} async={} committed={} on {}", new Object[]{request.isHandled(), request.isAsyncStarted(), response.isCommitted(), channel});
        }
    }

    protected void handleOptions(Request request, Response response) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCrossContextAsync(HttpChannel channel) throws IOException, ServletException {
        AsyncContextEvent event = channel.getState().getAsyncContextEvent();
        Request request = event.getHttpChannelState().getBaseRequest();
        HttpURI baseUri = event.getBaseURI();
        APIContext oldContext = request.getContext();
        HttpURI oldURI = request.getHttpURI();
        String oldPathInContext = request.getPathInContext();
        Fields oldQueryFields = request.getQueryFields();
        String encodedPathQuery = event.getDispatchPath();
        if (encodedPathQuery != null || baseUri != null) {
            try {
                if (encodedPathQuery == null) {
                    request.setHttpURI(baseUri);
                } else {
                    HttpURI.Mutable builder;
                    String encodedContextPath = URIUtil.encodePath((String)this.getContextPath());
                    if (!StringUtil.isEmpty((String)encodedContextPath) && (encodedPathQuery = URIUtil.canonicalPath((String)URIUtil.addEncodedPaths((String)encodedContextPath, (String)encodedPathQuery))) == null) {
                        throw new BadMessageException(500, "Bad dispatch path");
                    }
                    if (baseUri == null) {
                        baseUri = request.getHttpURI();
                    }
                    if (StringUtil.isEmpty((String)(builder = HttpURI.build((HttpURI)baseUri, (String)encodedPathQuery)).getParam())) {
                        builder.param(baseUri.getParam());
                    }
                    if (StringUtil.isEmpty((String)builder.getQuery())) {
                        builder.query(baseUri.getQuery());
                    }
                    request.setHttpURI((HttpURI)builder);
                    if (baseUri.getQuery() != null && request.getQueryString() != null) {
                        request.mergeQueryParameters(request.getHttpURI().getQuery(), request.getQueryString());
                    }
                }
                request.setContext(this._apiContext, event.getDispatchPath());
                this.handleAsync(channel, event, request);
            }
            finally {
                request.setContext(oldContext, oldPathInContext);
                request.setHttpURI(oldURI);
                request.setQueryFields(oldQueryFields);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAsync(HttpChannel channel) throws IOException, ServletException {
        HttpChannelState state = channel.getRequest().getHttpChannelState();
        AsyncContextEvent event = state.getAsyncContextEvent();
        Request baseRequest = channel.getRequest();
        HttpURI baseUri = event.getBaseURI();
        String encodedPathQuery = event.getDispatchPath();
        if (encodedPathQuery == null && baseUri == null) {
            this.handleAsync(channel, event, baseRequest);
            return;
        }
        HttpURI oldUri = baseRequest.getHttpURI();
        Fields oldQueryParams = baseRequest.getQueryFields();
        try {
            if (encodedPathQuery == null) {
                baseRequest.setHttpURI(baseUri);
            } else {
                HttpURI.Mutable builder;
                ServletContext servletContext = event.getServletContext();
                if (servletContext != null) {
                    String encodedContextPath;
                    String string = encodedContextPath = servletContext instanceof APIContext ? ((APIContext)servletContext).getContextHandler().getContextPathEncoded() : URIUtil.encodePath((String)servletContext.getContextPath());
                    if (!StringUtil.isEmpty((String)encodedContextPath) && (encodedPathQuery = URIUtil.normalizePath((String)URIUtil.addEncodedPaths((String)encodedContextPath, (String)encodedPathQuery))) == null) {
                        throw new BadMessageException(500, "Bad dispatch path");
                    }
                }
                if (baseUri == null) {
                    baseUri = oldUri;
                }
                if (StringUtil.isEmpty((String)(builder = HttpURI.build((HttpURI)baseUri, (String)encodedPathQuery)).getParam())) {
                    builder.param(baseUri.getParam());
                }
                if (StringUtil.isEmpty((String)builder.getQuery())) {
                    builder.query(baseUri.getQuery());
                }
                baseRequest.setHttpURI((HttpURI)builder);
                if (baseUri.getQuery() != null && baseRequest.getQueryString() != null) {
                    baseRequest.mergeQueryParameters(oldUri.getQuery(), baseRequest.getQueryString());
                }
            }
            baseRequest.setContext(null, baseRequest.getHttpURI().getDecodedPath());
            this.handleAsync(channel, event, baseRequest);
        }
        finally {
            baseRequest.setHttpURI(oldUri);
            baseRequest.setQueryFields(oldQueryParams);
            baseRequest.resetParameters();
        }
    }

    private void handleAsync(HttpChannel channel, AsyncContextEvent event, Request baseRequest) throws IOException, ServletException {
        String target = baseRequest.getPathInfo();
        HttpServletRequest request = Request.unwrap(event.getSuppliedRequest());
        HttpServletResponse response = Response.unwrap(event.getSuppliedResponse());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} on {}", new Object[]{request.getDispatcherType(), request.getMethod(), target, channel});
        }
        this.handle(target, baseRequest, request, response);
        if (LOG.isDebugEnabled()) {
            LOG.debug("handledAsync={} async={} committed={} on {}", new Object[]{channel.getRequest().isHandled(), request.isAsyncStarted(), response.isCommitted(), channel});
        }
    }

    public Resource getNestedResourceForTempDirName() {
        return this.getCoreContextHandler().getSuperResourceForTempDirName();
    }

    public class APIContext
    implements ServletContext {
        private final ContextHandler.ScopedContext _coreContext;
        protected boolean _enabled = true;
        protected boolean _extendedListenerTypes = false;
        private int _effectiveMajorVersion = 4;
        private int _effectiveMinorVersion = 0;

        protected APIContext() {
            this._coreContext = ContextHandler.this._coreContextHandler.getContext();
        }

        Context getCoreContext() {
            return this._coreContext;
        }

        public int getMajorVersion() {
            return 4;
        }

        public int getMinorVersion() {
            return 0;
        }

        public String getServerInfo() {
            return ContextHandler.this.getServer().getServerInfo();
        }

        public int getEffectiveMajorVersion() {
            return this._effectiveMajorVersion;
        }

        public int getEffectiveMinorVersion() {
            return this._effectiveMinorVersion;
        }

        public void setEffectiveMajorVersion(int v) {
            this._effectiveMajorVersion = v;
        }

        public void setEffectiveMinorVersion(int v) {
            this._effectiveMinorVersion = v;
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public ServletContext getContext(String path) {
            org.eclipse.jetty.server.handler.ContextHandler context = this.getContextHandler().getCoreContextHandler().getCrossContextHandler(path);
            if (context == null) {
                return null;
            }
            if (context == ContextHandler.this._coreContextHandler) {
                return this;
            }
            return new CrossContextServletContext(ContextHandler.this._coreContextHandler, context.getContext());
        }

        public String getMimeType(String file) {
            return this._coreContext.getMimeTypes().getMimeByExtension(file);
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String contextPath = this.getContextPath();
                HttpURI.Mutable uri = HttpURI.build((String)uriInContext);
                String pathInfo = uri.getDecodedPath();
                if (StringUtil.isEmpty((String)pathInfo)) {
                    return null;
                }
                if (!StringUtil.isEmpty((String)contextPath)) {
                    uri.path(URIUtil.addPaths((String)contextPath, (String)uri.getPath()));
                    pathInfo = uri.getDecodedPath().substring(contextPath.length());
                }
                return new Dispatcher(ContextHandler.this, (HttpURI)uri, pathInfo);
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                return null;
            }
        }

        public String getRealPath(String path) {
            if ((path = URIUtil.canonicalPath((String)path)) == null) {
                return null;
            }
            if (((String)path).length() == 0) {
                path = "/";
            } else if (((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            try {
                Resource resource = ContextHandler.this.getResource((String)path);
                if (resource != null) {
                    for (Resource r : resource) {
                        Path resourcePath;
                        if (!Resources.exists((Resource)r) || (resourcePath = r.getPath()) == null) continue;
                        Object realPath = resourcePath.normalize().toString();
                        if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                            realPath = (String)realPath + "/";
                        }
                        return realPath;
                    }
                    return null;
                }
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            try {
                String canonicalPath = URIUtil.canonicalPath((String)path);
                if (canonicalPath == null) {
                    return null;
                }
                if (!canonicalPath.startsWith("/")) {
                    throw new MalformedURLException(path);
                }
                Resource resource = ContextHandler.this.getResource(canonicalPath);
                if (resource != null && resource.exists()) {
                    return resource.getURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (MalformedURLException)new MalformedURLException(path).initCause(e);
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                if (url == null) {
                    return null;
                }
                Resource r = ResourceFactory.of((Container)ContextHandler.this).newResource(url);
                if (r.isDirectory()) {
                    return null;
                }
                return IOResources.asInputStream((Resource)r);
            }
            catch (Throwable e) {
                LOG.trace("IGNORED", e);
                return null;
            }
        }

        public Set<String> getResourcePaths(String path) {
            if ((path = URIUtil.canonicalPath((String)path)) == null) {
                return null;
            }
            return ContextHandler.this.getResourcePaths(path);
        }

        public void log(Exception exception, String msg) {
            ContextHandler.this._logger.warn(msg, (Throwable)exception);
        }

        public void log(String msg) {
            ContextHandler.this._logger.info(msg);
        }

        public void log(String message, Throwable throwable) {
            if (throwable == null) {
                ContextHandler.this._logger.warn(message);
            } else {
                ContextHandler.this._logger.warn(message, throwable);
            }
        }

        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public Object getAttribute(String name) {
            return this._coreContext.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this._coreContext.getAttributeNameSet());
        }

        public void setAttribute(String name, Object value) {
            Object oldValue = this._coreContext.setAttribute(name, value);
            if (!ContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._apiContext, name, oldValue == null ? value : oldValue);
                for (ServletContextAttributeListener listener : ContextHandler.this._servletContextAttributeListeners) {
                    if (oldValue == null) {
                        listener.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        listener.attributeRemoved(event);
                        continue;
                    }
                    listener.attributeReplaced(event);
                }
            }
        }

        public void removeAttribute(String name) {
            Object oldValue = this._coreContext.removeAttribute(name);
            if (oldValue != null && !ContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._apiContext, name, oldValue);
                for (ServletContextAttributeListener listener : ContextHandler.this._servletContextAttributeListeners) {
                    listener.attributeRemoved(event);
                }
            }
        }

        public String getServletContextName() {
            String name = ContextHandler.this.getDisplayName();
            if (name == null) {
                name = ContextHandler.this.getContextPath();
            }
            return name;
        }

        public String getContextPath() {
            return ContextHandler.this.getRequestContextPath();
        }

        public String toString() {
            return "ServletContext@" + ContextHandler.this.toString();
        }

        public boolean setInitParameter(String name, String value) {
            if (ContextHandler.this.getInitParameter(name) != null) {
                return false;
            }
            ContextHandler.this.getInitParams().put(name, value);
            return true;
        }

        public void addListener(String className) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                ClassLoader classLoader = this._coreContext.getClassLoader();
                Class<?> clazz = classLoader == null ? Loader.loadClass((String)className) : classLoader.loadClass(className);
                this.addListener(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public <T extends EventListener> void addListener(T t) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            this.checkListener(t.getClass());
            ContextHandler.this.addEventListener(t);
            ContextHandler.this.addProgrammaticListener(t);
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                EventListener e = this.createListener(listenerClass);
                this.addListener(e);
            }
            catch (ServletException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public void checkListener(Class<? extends EventListener> listener) throws IllegalStateException {
            int startIndex;
            boolean ok = false;
            for (int i = startIndex = this.isExtendedListenerTypes() ? 0 : 1; i < SERVLET_LISTENER_TYPES.length; ++i) {
                if (!SERVLET_LISTENER_TYPES[i].isAssignableFrom(listener)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new IllegalArgumentException("Inappropriate listener class " + listener.getName());
            }
        }

        public void setExtendedListenerTypes(boolean extended) {
            this._extendedListenerTypes = extended;
        }

        public boolean isExtendedListenerTypes() {
            return this._extendedListenerTypes;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration<Servlet> getServlets() {
            return null;
        }

        public Enumeration<String> getServletNames() {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            return null;
        }

        public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
            return null;
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            return (T)((Servlet)this.createInstance(clazz));
        }

        public ServletRegistration getServletRegistration(String servletName) {
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            return null;
        }

        public <T> T createInstance(Class<T> clazz) throws ServletException {
            try {
                T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (T)this.getCoreContext().decorate(instance);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            return (T)((Filter)this.createInstance(clazz));
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return null;
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            return (T)((EventListener)this.createInstance(clazz));
        }

        public int getSessionTimeout() {
            return 0;
        }

        public void setSessionTimeout(int sessionTimeout) {
        }

        public String getRequestCharacterEncoding() {
            return ContextHandler.this.getDefaultRequestCharacterEncoding();
        }

        public void setRequestCharacterEncoding(String encoding) {
            ContextHandler.this.setDefaultRequestCharacterEncoding(encoding);
        }

        public String getResponseCharacterEncoding() {
            return ContextHandler.this.getDefaultResponseCharacterEncoding();
        }

        public void setResponseCharacterEncoding(String encoding) {
            ContextHandler.this.setDefaultResponseCharacterEncoding(encoding);
        }

        public ClassLoader getClassLoader() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (!ContextHandler.this.isUsingSecurityManager()) {
                return this._coreContext.getClassLoader();
            }
            ClassLoader classLoader = this._coreContext.getClassLoader();
            for (ClassLoader callerLoader = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getClassLoader(); callerLoader != null; callerLoader = callerLoader.getParent()) {
                if (callerLoader != classLoader) continue;
                return classLoader;
            }
            SecurityUtils.checkPermission((Permission)new RuntimePermission("getClassLoader"));
            return classLoader;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            LOG.warn(ContextHandler.UNIMPLEMENTED_USE_SERVLET_CONTEXT_HANDLER, (Object)"getJspConfigDescriptor()");
            return null;
        }

        public void setJspConfigDescriptor(JspConfigDescriptor d) {
        }

        public void declareRoles(String ... roleNames) {
            if (!ContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public String getVirtualServerName() {
            String[] hosts = ContextHandler.this.getVirtualHosts();
            if (hosts != null && hosts.length > 0) {
                return hosts[0];
            }
            return null;
        }
    }

    public class CoreContextHandler
    extends org.eclipse.jetty.server.handler.ContextHandler
    implements Request.Handler {
        CoreContextHandler() {
            super.setHandler((org.eclipse.jetty.server.Handler)new CoreToNestedHandler());
            this.installBean(ContextHandler.this, true);
        }

        public void makeTempDirectory() throws Exception {
            super.makeTempDirectory();
        }

        public String getCanonicalNameForTmpDir() {
            return super.getCanonicalNameForTmpDir();
        }

        public Resource getResourceForTempDirName() {
            return ContextHandler.this.getNestedResourceForTempDirName();
        }

        private Resource getSuperResourceForTempDirName() {
            return super.getResourceForTempDirName();
        }

        public void setTempDirectory(File dir) {
            super.setTempDirectory(dir);
            this.setAttribute("javax.servlet.context.tempdir", super.getTempDirectory());
        }

        public void setContextPath(String contextPath) {
            super.setContextPath(contextPath);
            ContextHandler.this._contextPathEncoded = URIUtil.encodePath((String)contextPath);
            if (this.getServer() != null && this.getServer().isRunning()) {
                this.getServer().getDescendants(ContextHandlerCollection.class).forEach(ContextHandlerCollection::mapContexts);
            }
        }

        protected void doStart() throws Exception {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            if (this.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            try {
                super.doStart();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }

        public void createTempDirectory() {
            super.createTempDirectory();
        }

        protected void doStop() throws Exception {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            if (this.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            try {
                super.doStop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }

        public void insertHandler(Handler.Singleton handler) {
            Handler.Singleton tail = handler.getTail();
            if (tail.getHandler() != null) {
                throw new IllegalArgumentException("bad tail of inserted wrapper chain");
            }
            tail.setHandler(this.getHandler());
            super.setHandler((org.eclipse.jetty.server.Handler)handler);
        }

        public void setHandler(org.eclipse.jetty.server.Handler handler) {
            throw new UnsupportedOperationException();
        }

        public void setServer(Server server) {
            super.setServer(server);
            ContextHandler.this.setServer(server);
        }

        protected ContextHandler.ScopedContext newContext() {
            return new CoreContext();
        }

        protected ContextRequest wrapRequest(org.eclipse.jetty.server.Request request, org.eclipse.jetty.server.Response response) {
            HttpChannel httpChannel = (HttpChannel)request.getComponents().getCache().getAttribute(HttpChannel.class.getName());
            if (httpChannel == null) {
                httpChannel = new HttpChannel(ContextHandler.this, request.getConnectionMetaData());
                request.getComponents().getCache().setAttribute(HttpChannel.class.getName(), (Object)httpChannel);
            } else if (httpChannel.getContextHandler() == ContextHandler.this && !request.getContext().isCrossContextDispatch(request)) {
                httpChannel.recycle();
            } else {
                httpChannel = new HttpChannel(ContextHandler.this, request.getConnectionMetaData());
            }
            CoreContextRequest coreContextRequest = new CoreContextRequest(request, this.getContext(), httpChannel);
            httpChannel.onRequest(coreContextRequest);
            HttpChannel channel = httpChannel;
            org.eclipse.jetty.server.Request.addCompletionListener((org.eclipse.jetty.server.Request)coreContextRequest, x -> {
                if (!request.getHeaders().contains(HttpHeader.SEC_WEBSOCKET_VERSION)) {
                    channel.recycle();
                }
            });
            return coreContextRequest;
        }

        protected void notifyEnterScope(org.eclipse.jetty.server.Request coreRequest) {
            Request request;
            __context.set(ContextHandler.this._apiContext);
            super.notifyEnterScope(coreRequest);
            if (coreRequest instanceof CoreContextRequest) {
                CoreContextRequest coreContextRequest = (CoreContextRequest)coreRequest;
                request = coreContextRequest.getHttpChannel().getRequest();
            } else {
                request = null;
            }
            Request request2 = request;
            ContextHandler.this.enterScope(request2, "Entered core context");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyExitScope(org.eclipse.jetty.server.Request coreRequest) {
            try {
                Request request;
                if (coreRequest instanceof CoreContextRequest) {
                    CoreContextRequest coreContextRequest = (CoreContextRequest)coreRequest;
                    request = coreContextRequest.getHttpChannel().getRequest();
                } else {
                    request = null;
                }
                Request request2 = request;
                ContextHandler.this.exitScope(request2);
                super.notifyExitScope(coreRequest);
            }
            finally {
                __context.set(null);
            }
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            names.add(ContextHandler.MAX_FORM_KEYS_KEY);
            names.add(ContextHandler.MAX_FORM_CONTENT_SIZE_KEY);
            return Collections.unmodifiableSet(names);
        }

        private class CoreToNestedHandler
        extends Handler.Abstract {
            private CoreToNestedHandler() {
            }

            public boolean handle(org.eclipse.jetty.server.Request coreRequest, org.eclipse.jetty.server.Response response, Callback callback) {
                HttpChannel httpChannel = (HttpChannel)org.eclipse.jetty.server.Request.get((org.eclipse.jetty.server.Request)coreRequest, CoreContextRequest.class, CoreContextRequest::getHttpChannel);
                Objects.requireNonNull(httpChannel).onProcess(response, callback);
                httpChannel.handle();
                return true;
            }
        }

        class CoreContext
        extends ContextHandler.ScopedContext {
            CoreContext() {
                super((org.eclipse.jetty.server.handler.ContextHandler)CoreContextHandler.this);
            }

            public APIContext getAPIContext() {
                return ContextHandler.this._apiContext;
            }

            public Object getAttribute(String name) {
                return switch (name) {
                    case ContextHandler.MAX_FORM_KEYS_KEY -> ContextHandler.this.getMaxFormKeys();
                    case ContextHandler.MAX_FORM_CONTENT_SIZE_KEY -> ContextHandler.this.getMaxFormContentSize();
                    default -> super.getAttribute(name);
                };
            }

            public Object setAttribute(String name, Object attribute) {
                return switch (name) {
                    case ContextHandler.MAX_FORM_KEYS_KEY -> {
                        int oldValue = ContextHandler.this.getMaxFormKeys();
                        if (attribute == null) {
                            ContextHandler.this.setMaxFormKeys(1000);
                        } else {
                            ContextHandler.this.setMaxFormKeys(Integer.parseInt(attribute.toString()));
                        }
                        yield oldValue;
                    }
                    case ContextHandler.MAX_FORM_CONTENT_SIZE_KEY -> {
                        int oldValue = ContextHandler.this.getMaxFormContentSize();
                        if (attribute == null) {
                            ContextHandler.this.setMaxFormContentSize(200000);
                        } else {
                            ContextHandler.this.setMaxFormContentSize(Integer.parseInt(attribute.toString()));
                        }
                        yield oldValue;
                    }
                    default -> super.setAttribute(name, attribute);
                };
            }
        }
    }

    public static enum ContextStatus {
        NOTSET,
        INITIALIZED,
        DESTROYED;

    }

    public static interface ContextScopeListener
    extends EventListener {
        public void enterScope(APIContext var1, Request var2, Object var3);

        public void exitScope(APIContext var1, Request var2);
    }

    public static class CoreContextRequest
    extends ContextRequest {
        private final HttpChannel _httpChannel;
        private SessionManager _sessionManager;
        private ManagedSession _managedSession;
        private List<ManagedSession> _managedSessions;
        AbstractSessionManager.RequestedSession _requestedSession;

        protected CoreContextRequest(org.eclipse.jetty.server.Request wrapped, ContextHandler.ScopedContext context, HttpChannel httpChannel) {
            super(context, wrapped);
            this._httpChannel = httpChannel;
        }

        public String changeSessionId() {
            if (this._managedSession == null) {
                throw new IllegalStateException("No session");
            }
            if (!this._managedSession.isValid()) {
                return this._managedSession.getId();
            }
            HttpSession httpSession = (HttpSession)this._managedSession.getApi();
            if (httpSession == null) {
                throw new IllegalStateException("No session");
            }
            ManagedSession session = this._managedSession;
            session.renewId((org.eclipse.jetty.server.Request)this, this._httpChannel.getCoreResponse());
            return httpSession.getId();
        }

        public HttpChannel getHttpChannel() {
            return this._httpChannel;
        }

        public ManagedSession getManagedSession() {
            return this._managedSession;
        }

        public ManagedSession getManagedSession(SessionManager manager) {
            if (this._managedSessions == null) {
                return null;
            }
            for (ManagedSession s : this._managedSessions) {
                if (manager != s.getSessionManager() || !s.isValid()) continue;
                return s;
            }
            return null;
        }

        public void setManagedSession(ManagedSession managedSession) {
            this._managedSession = managedSession;
            this.addManagedSession(managedSession);
        }

        private void addManagedSession(ManagedSession managedSession) {
            if (managedSession == null) {
                return;
            }
            if (this._managedSessions == null) {
                this._managedSessions = new ArrayList<ManagedSession>();
            }
            if (!this._managedSessions.contains(managedSession)) {
                this._managedSessions.add(managedSession);
            }
        }

        public SessionManager getSessionManager() {
            return this._sessionManager;
        }

        public void setRequestedSession(AbstractSessionManager.RequestedSession requestedSession) {
            this._requestedSession = requestedSession;
        }

        public void completeSessions() {
            if (this._managedSessions != null) {
                for (ManagedSession s : this._managedSessions) {
                    if (s.getSessionManager() == null) continue;
                    s.getSessionManager().getContext().run(() -> this.completeSession(s), (org.eclipse.jetty.server.Request)this);
                }
            }
        }

        public void commitSessions() {
            if (this._managedSessions != null) {
                for (ManagedSession s : this._managedSessions) {
                    if (s.getSessionManager() == null) continue;
                    s.getSessionManager().getContext().run(() -> this.commitSession(s), (org.eclipse.jetty.server.Request)this);
                }
            }
        }

        private void commitSession(ManagedSession session) {
            if (session == null) {
                return;
            }
            SessionManager manager = session.getSessionManager();
            if (manager == null) {
                return;
            }
            manager.commit(session);
        }

        private void completeSession(ManagedSession session) {
            if (session == null) {
                return;
            }
            SessionManager manager = session.getSessionManager();
            if (manager == null) {
                return;
            }
            manager.complete(session);
        }

        public AbstractSessionManager.RequestedSession getRequestedSession() {
            return this._requestedSession;
        }

        public void setSessionManager(SessionManager sessionManager) {
            this._sessionManager = sessionManager;
        }

        public Session getSession(boolean create) {
            if (this._managedSession != null) {
                if (this._sessionManager != null && !this._managedSession.isValid()) {
                    this._managedSession = null;
                } else {
                    return this._managedSession;
                }
            }
            if (!create) {
                return null;
            }
            if (this._httpChannel.getResponse().isCommitted()) {
                throw new IllegalStateException("Response is committed");
            }
            if (this._sessionManager == null) {
                throw new IllegalStateException("No SessionManager");
            }
            this._sessionManager.newSession((org.eclipse.jetty.server.Request)this, this._requestedSession == null ? null : this._requestedSession.sessionId(), this::setManagedSession);
            if (this._managedSession == null) {
                throw new IllegalStateException("Create session failed");
            }
            HttpCookie cookie = this._sessionManager.getSessionCookie(this._managedSession, this.isSecure());
            if (cookie != null) {
                this._httpChannel.getResponse().replaceCookie(cookie);
            }
            return this._managedSession;
        }
    }
}

