/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.MessageDigest;
import java.sql.SQLException;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.sql.CharacterSet;

class AggregateByteArray
extends SimpleByteArray {
    protected ByteArray extension;

    AggregateByteArray(Diagnosable diagnosable, byte[] _bytes, ByteArray _extension) {
        super(diagnosable, _bytes);
        this.extension = _extension;
    }

    @Override
    long length() {
        return (long)this.bytes.length + this.extension.length();
    }

    @Override
    void put(long index, byte value) throws SQLException {
        if (index < (long)this.bytes.length) {
            super.put(index, value);
        } else {
            this.extension.put(index - (long)this.bytes.length, value);
        }
    }

    @Override
    byte get(long index) {
        if (index < (long)this.bytes.length) {
            return super.get(index);
        }
        return this.extension.get(index - (long)this.bytes.length);
    }

    @Override
    void put(long offset, byte[] src, int srcOffset, int length) throws SQLException {
        assert (offset < (long)this.bytes.length == offset + (long)length <= (long)this.bytes.length) : "offset:" + offset + " length:" + length + " bytes.length:" + this.bytes.length;
        if (offset < (long)this.bytes.length) {
            super.put(offset, src, srcOffset, length);
        } else {
            this.extension.put(offset - (long)this.bytes.length, src, srcOffset, length);
        }
    }

    @Override
    void get(long offset, byte[] dest, int destOffset, int length) {
        assert (offset < (long)this.bytes.length == offset + (long)length <= (long)this.bytes.length) : "offset:" + offset + " length:" + length + " bytes.length:" + this.bytes.length;
        if (offset < (long)this.bytes.length) {
            super.get(offset, dest, destOffset, length);
        } else {
            this.extension.get(offset - (long)this.bytes.length, dest, destOffset, length);
        }
    }

    @Override
    char[] getChars(long offset, int lengthInBytes, CharacterSet charSet, int[] out_lengthInChars) throws SQLException {
        assert (offset < (long)this.bytes.length == offset + (long)lengthInBytes <= (long)this.bytes.length) : "offset:" + offset + " lengthInBytes:" + lengthInBytes + " bytes.length:" + this.bytes.length;
        if (offset < (long)this.bytes.length) {
            return super.getChars(offset, lengthInBytes, charSet, out_lengthInChars);
        }
        return this.extension.getChars(offset - (long)this.bytes.length, lengthInBytes, charSet, out_lengthInChars);
    }

    @Override
    long updateChecksum(long offset, int length, CRC64 crc, long checksum) {
        assert (offset < (long)this.bytes.length == offset + (long)length <= (long)this.bytes.length) : "offset:" + offset + " length:" + length + " bytes.length:" + this.bytes.length;
        if (offset < (long)this.bytes.length) {
            return super.updateChecksum(offset, length, crc, checksum);
        }
        return this.extension.updateChecksum(offset - (long)this.bytes.length, length, crc, checksum);
    }

    @Override
    void updateDigest(MessageDigest md, long valOffset, int valLen) {
        super.updateDigest(md, valOffset, valLen);
    }

    @Override
    byte[] getBlockBasic(long offset, int[] initialByteIndex) {
        if (offset < (long)this.bytes.length) {
            return super.getBlockBasic(offset, initialByteIndex);
        }
        return this.extension.getBlockBasic(offset, initialByteIndex);
    }

    @Override
    void free() {
        super.free();
        this.extension.free();
    }
}

