/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class UndoRedoHandler {
    private final LinkedList<Command> commands = new LinkedList();
    private final LinkedList<Command> redoCommands = new LinkedList();
    private final LinkedList<CommandQueueListener> listenerCommands = new LinkedList();
    private final LinkedList<CommandQueuePreciseListener> preciseListenerCommands = new LinkedList();

    public static UndoRedoHandler getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private UndoRedoHandler() {
    }

    public List<Command> getUndoCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public List<Command> getRedoCommands() {
        return Collections.unmodifiableList(this.redoCommands);
    }

    public Command getLastCommand() {
        return this.commands.peekLast();
    }

    public boolean hasUndoCommands() {
        return !this.commands.isEmpty();
    }

    public boolean hasRedoCommands() {
        return !this.redoCommands.isEmpty();
    }

    public void addNoRedraw(Command c) {
        this.addNoRedraw(c, true);
    }

    public void addNoRedraw(Command c, boolean execute) {
        CheckParameterUtil.ensureParameterNotNull(c, "c");
        if (execute) {
            c.executeCommand();
        }
        this.commands.add(c);
        if (this.commands.size() > Config.getPref().getInt("undo.max", 1000)) {
            this.commands.removeFirst();
        }
        this.redoCommands.clear();
    }

    public void afterAdd(Command cmd) {
        if (cmd != null) {
            this.fireEvent(new CommandAddedEvent(this, cmd));
        }
        this.fireCommandsChanged();
    }

    public void afterAdd(List<? extends Command> cmds) {
        if (cmds != null) {
            for (Command command : cmds) {
                this.fireEvent(new CommandAddedEvent(this, command));
            }
        }
        this.fireCommandsChanged();
    }

    public void add(Command c, boolean execute) {
        this.addNoRedraw(c, execute);
        this.afterAdd(c);
    }

    public synchronized void add(Command c) {
        this.addNoRedraw(c, true);
        this.afterAdd(c);
    }

    public void undo() {
        this.undo(1);
    }

    public synchronized void undo(int num) {
        if (this.commands.isEmpty()) {
            return;
        }
        GuiHelper.runInEDTAndWait(() -> {
            DataSet ds = OsmDataManager.getInstance().getEditDataSet();
            if (ds != null) {
                ds.beginUpdate();
            }
            try {
                for (int i = 1; i <= num; ++i) {
                    Command c = this.commands.removeLast();
                    try {
                        c.undoCommand();
                    }
                    catch (Exception e) {
                        this.commands.add(c);
                        throw e;
                    }
                    this.redoCommands.addFirst(c);
                    this.fireEvent(new CommandUndoneEvent(this, c));
                    if (!this.commands.isEmpty()) continue;
                    break;
                }
            }
            finally {
                if (ds != null) {
                    ds.endUpdate();
                }
            }
            this.fireCommandsChanged();
        });
    }

    public void redo() {
        this.redo(1);
    }

    public synchronized void redo(int num) {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            Command c = this.redoCommands.removeFirst();
            c.executeCommand();
            this.commands.add(c);
            this.fireEvent(new CommandRedoneEvent(this, c));
            if (this.redoCommands.isEmpty()) break;
        }
        this.fireCommandsChanged();
    }

    private void fireCommandsChanged() {
        for (CommandQueueListener l : this.listenerCommands) {
            l.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    private void fireEvent(CommandQueueEvent e) {
        this.preciseListenerCommands.forEach(e::fire);
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireEvent(new CommandQueueCleanedEvent(this, null));
        this.fireCommandsChanged();
    }

    public synchronized void clean(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        boolean changed = false;
        changed |= this.commands.removeIf(c -> c.getAffectedDataSet() == dataSet);
        if (changed |= this.redoCommands.removeIf(c -> c.getAffectedDataSet() == dataSet)) {
            this.fireEvent(new CommandQueueCleanedEvent(this, dataSet));
            this.fireCommandsChanged();
        }
    }

    public void removeCommandQueueListener(CommandQueueListener l) {
        this.listenerCommands.remove(l);
    }

    public boolean addCommandQueueListener(CommandQueueListener l) {
        return this.listenerCommands.add(l);
    }

    public void removeCommandQueuePreciseListener(CommandQueuePreciseListener l) {
        this.preciseListenerCommands.remove(l);
    }

    public boolean addCommandQueuePreciseListener(CommandQueuePreciseListener l) {
        return this.preciseListenerCommands.add(l);
    }

    public static final class CommandRedoneEvent
    extends CommandQueueEvent {
        private static final long serialVersionUID = 1L;
        private final Command cmd;

        private CommandRedoneEvent(UndoRedoHandler source, Command cmd) {
            super(source);
            this.cmd = Objects.requireNonNull(cmd);
        }

        public Command getCommand() {
            return this.cmd;
        }

        @Override
        void fire(CommandQueuePreciseListener listener) {
            listener.commandRedone(this);
        }
    }

    public static final class CommandUndoneEvent
    extends CommandQueueEvent {
        private static final long serialVersionUID = 1L;
        private final Command cmd;

        private CommandUndoneEvent(UndoRedoHandler source, Command cmd) {
            super(source);
            this.cmd = Objects.requireNonNull(cmd);
        }

        public Command getCommand() {
            return this.cmd;
        }

        @Override
        void fire(CommandQueuePreciseListener listener) {
            listener.commandUndone(this);
        }
    }

    public static final class CommandQueueCleanedEvent
    extends CommandQueueEvent {
        private static final long serialVersionUID = 1L;
        private final DataSet ds;

        private CommandQueueCleanedEvent(UndoRedoHandler source, DataSet ds) {
            super(source);
            this.ds = ds;
        }

        public DataSet getDataSet() {
            return this.ds;
        }

        @Override
        void fire(CommandQueuePreciseListener listener) {
            listener.cleaned(this);
        }
    }

    public static final class CommandAddedEvent
    extends CommandQueueEvent {
        private static final long serialVersionUID = 1L;
        private final Command cmd;

        private CommandAddedEvent(UndoRedoHandler source, Command cmd) {
            super(source);
            this.cmd = Objects.requireNonNull(cmd);
        }

        public Command getCommand() {
            return this.cmd;
        }

        @Override
        void fire(CommandQueuePreciseListener listener) {
            listener.commandAdded(this);
        }
    }

    static abstract class CommandQueueEvent
    extends EventObject {
        protected CommandQueueEvent(UndoRedoHandler source) {
            super(Objects.requireNonNull(source));
        }

        abstract void fire(CommandQueuePreciseListener var1);

        @Override
        public final UndoRedoHandler getSource() {
            return (UndoRedoHandler)super.getSource();
        }
    }

    public static interface CommandQueuePreciseListener {
        public void commandAdded(CommandAddedEvent var1);

        public void cleaned(CommandQueueCleanedEvent var1);

        public void commandUndone(CommandUndoneEvent var1);

        public void commandRedone(CommandRedoneEvent var1);
    }

    @FunctionalInterface
    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    private static final class InstanceHolder {
        static final UndoRedoHandler INSTANCE = new UndoRedoHandler();

        private InstanceHolder() {
        }
    }
}

