/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyWordSelectionHandler
extends ExtendWordSelectionHandlerBase {
    private static final Logger LOG = Logger.getInstance(GroovyWordSelectionHandler.class);

    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            GroovyWordSelectionHandler.$$$reportNull$$$0(0);
        }
        return (e instanceof GroovyPsiElement || e.getLanguage() == GroovyLanguage.INSTANCE) && e.getNode().getElementType() != GroovyTokenTypes.mDOLLAR;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List<TextRange> ranges;
        TextRange originalRange;
        if (e == null) {
            GroovyWordSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GroovyWordSelectionHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyWordSelectionHandler.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((originalRange = e.getTextRange()).getEndOffset() <= editorText.length(), (Object)(String.valueOf(((Object)((Object)this)).getClass()) + "; " + String.valueOf(e)));
        if (GroovyWordSelectionHandler.isSeparateStatement(e)) {
            ranges = ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)originalRange, (boolean)true);
            if (ranges.size() == 1 && ranges.contains(originalRange)) {
                ranges = ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)originalRange, (boolean)false);
            }
        } else {
            ranges = new ArrayList();
            ranges.add(e.getTextRange());
        }
        SelectWordUtil.addWordOrLexemeSelection((boolean)editor.getSettings().isCamelWords(), (Editor)editor, (int)cursorOffset, ranges);
        return ranges;
    }

    private static boolean isSeparateStatement(PsiElement e) {
        return e instanceof LeafPsiElement || e instanceof GrExpression && PsiUtil.isExpressionStatement(e) || e instanceof GrVariableDeclaration || e instanceof GrStatement && !(e instanceof GrExpression) || e instanceof GrMethod || e instanceof GrClassInitializer || e instanceof GrImportStatement || e instanceof GrPackageDefinition || e instanceof GrOpenBlock || e instanceof GrTypeDefinition && !((GrTypeDefinition)e).isAnonymous();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/selection/GroovyWordSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

